import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class EliminateNearFP2 {

    public static boolean main(Block X) {
	for(int i=0;i<4;++i) {
	    if(inBox(i,X.B[i],Box.TOL,Box.SCALE)==false) return false;
	}
	return true;
    }


    public static boolean inBox(int j,Box B,int tol,int scale) {
	GaussianInteger[] z=B.toGaussianVertices();
	for(int i=0;i<z.length;++i) {
	    if(inBox(j,z[i],scale)==false) return false;
	}
	return true;
    }


    /**This tests whether the complex number represented
       by the Gaussian integer is contained in the jth
       factor of the special neighborhood of the TBP.*/

    public static boolean inBox(int j,GaussianInteger z,int scale) {
	if(j==0) return inBox0(z,scale);
	if(j==1) return inBox1(z,scale);
	if(j==2) return inBox2(z,scale);
	if(j==3) return inBox3(z,scale);
	return false;
    }

    /**q should be a smallish power of 2*/
    public static long scaleNum(long p,long q,long scale) {
	long x=(long)(1.0*p*Math.pow(2,scale)/q);
	return x;
    }


    public static boolean inBox0(GaussianInteger g,int scale) {	
        long x0=scaleNum(1,1,scale);
        long x1=scaleNum(17,16,scale);	
        if(g.x<x0) return false;
	if(g.x>x1) return false;
	return true;
    }

    public static boolean inBox1(GaussianInteger g,int scale) {
	long x0=scaleNum(-7,16,scale);
	long x1=0;
	if(g.x<x0) return false;
	if(g.x>x1) return false;
	if(insideCircle(g,3,4,scale)==true) return false;
	if(outsideCircle(g,1,1,scale)==true) return false;
	return true;
    }

    public static boolean inBox2(GaussianInteger g,int scale) {
	long x0=scaleNum(-1,16,scale);
	long x1=scaleNum(+1,16,scale);
	long y0=scaleNum(0,1,scale);
	long y1=scaleNum(1,4,scale);
	if(g.x<x0) return false;
	if(g.x>x1) return false;
	if(g.y<y0) return false;
	if(g.y>y1) return false;
	return true;
    }

    public static boolean inBox3(GaussianInteger g,int scale) {
	long y0=scaleNum(1,8,scale);
	long y1=scaleNum(3,4,scale);
	if(g.y<y0) return false;
	if(g.y>y1) return false;
	if(insideCircle(g,31,32,scale)==true) return false;
	if(outsideCircle(g,35,32,scale)==true) return false;
	return true;
    }


    public static boolean insideCircle(GaussianInteger g,long p,long q,long scale) {
	long r=scaleNum(p,q,scale);
	long s=g.x*g.x+g.y*g.y;
	if(s<r*r) return true;
	return false;
    }

    public static boolean outsideCircle(GaussianInteger g,long p,long q,long scale) {
	long r=scaleNum(p,q,scale);
	long s=g.x*g.x+g.y*g.y;
	if(s>r*r) return true;
	return false;
    }


    public static boolean inBox3X(GaussianInteger g,int scale) {
	long x0=scaleNum(-17,16,scale);
	long x1=scaleNum(-5,8,scale);
	long y0=scaleNum(1,8,scale);
	long y1=scaleNum(3,4,scale);
	if(g.x<x0) return false;
	if(g.x>x1) return false;
	if(g.y<y0) return false;
	if(g.y>y1) return false;
	long x2=scaleNum(-7,8,scale);
	long y2=scaleNum(3,8,scale);
	if((g.x>x2)&&(g.y<y2)) return false;
	long x3=scaleNum(-3,4,scale);
	long y3=scaleNum(5,8,scale);
	if((g.x>x3)&&(g.y<y3)) return false;	
        long x4=scaleNum(-7,8,scale);
	long y4=scaleNum(5,8,scale);
	if((g.x<x4)&&(g.y>y4)) return false;	
        long x5=scaleNum(-1,1,scale);
	long y5=scaleNum(3,8,scale);
	if((g.x<x5)&&(g.y>y5)) return false;
	return true;
    }


}
