import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class EliminatePermuted {

    /**This routine eliminates a block if it is
       irrelevant.*/

    public static boolean main(Block X) {
	long ONE=(long)(Math.pow(2,Box.SCALE));  //scaled 1
	if(nearOrigin(X.B[0],Box.SCALE)==true) return true;
	if(nearOrigin(X.B[1],Box.SCALE)==true) return true;
	if(nearOrigin(X.B[2],Box.SCALE)==true) return true;
	if(nearOrigin(X.B[3],Box.SCALE)==true) return true;
	if(X.B[0].xMax()<=-X.B[1].yMax()) return true;
	if(X.B[0].xMax()<=-X.B[2].xMax()) return true;
	if(X.B[0].xMax()<=+X.B[3].yMin()) return true;
	if(X.B[1].yMin()>=0) return true;
	if(X.B[2].yMax()<=0) return true;
	if(X.B[2].yMin()>=X.B[3].yMax()) return true;

	double test1=SphericalMeasures.dotMaxUpper(X.B[3],X.B[4]);
	double test2=dotMin(X,1);
	if(test1<test2) return true;
	return false;
    }


    public static double dotMin(Block X,int j) {
	double min=100000;
	for(int i=0;i<5;++i) {
	    if(i!=j) {
		double test=SphericalMeasures.dotMinLower(X.B[i],X.B[j]);
		if(min>test) min=test;
	    }
	}
	return min;
    }








    public static boolean nearOrigin(Box B,int scale) {
	GaussianInteger[] z=B.toGaussianVertices();
	for(int i=0;i<z.length;++i) {
	    if(insideCircle(z[i],5,16,scale)==false) return false;
	}
	return true;
    }

    public static boolean insideCircle(GaussianInteger g,long p,long q,long scale) {
	long r=scaleNum(p,q,scale);
	long s=g.x*g.x+g.y*g.y;
	if(s<r*r) return true;
	return false;
    }


    /**q should be a smallish power of 2*/
    public static long scaleNum(long p,long q,long scale) {
	long x=(long)(1.0*p*Math.pow(2,scale)/q);
	return x;
    }



}

