import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This checks whether the box is within the canonical
   neighborhood of the TBP*/

public class EliminateRim {


    public static boolean main(Block X) {
	for(int i=0;i<4;++i) {
	    if(inBox(i,X.B[i])==false) return false;
	}
	return true;
    }

    public static boolean inBox(int j,Box B) {
	Complex[] z=B.toVertices();
	if(j!=2) return inRim(z);
	return inBox(z);
    }

    public static boolean inRim(Complex[] z) {
	for(int i=0;i<z.length;++i) {
	    boolean test=inRim(z[i]);
	    if(test==false) return false;
	}
	return true;
    }

    public static boolean inBox(Complex[] z) {
	for(int i=0;i<z.length;++i) {
	    boolean test=inBox(z[i]);
	    if(test==false) return false;
	}
	return true;
    }

    public static boolean inRim(Complex z) {
	double x=z.norm();
	if(x<1-1.0/2) return false;
	if(x>1+1.0/2) return false;
	return true;
    }

    public static boolean inBox(Complex z) {
	if(z.x<-1.0/2) return false;
	if(z.x>+1.0/2) return false;
	if(z.y<-1.0/2) return false;
	if(z.y>+1.0/2) return false;
	return true;
    }

}



