import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class IntervalEnergy {


    /**This is the fundamental routine*/

    public static Interval interaction(int e,IntervalVector V1,IntervalVector V2) {
	Interval TWO=new Interval(2.0,2.0);
	Interval a=IntervalVector.dot(V1,V2);
	Interval b=Interval.plus(TWO,Interval.times(TWO,a));
	b=Interval.pow(b,e);
	return b;
    }

    /**This routine computes the total energy of 
       4 points in the plane, plus the point at
       infinity.  These 4 points are  mapped 
       stereographically to the unit sphere, and
       the vector (0,0,1) is included as the 
       image of infinity.  */

    public static Interval energy(int e,GaussianInteger[] z) {
	IntervalVector[] V=new IntervalVector[5];
	for(int i=0;i<4;++i) V[i]=IntervalVector.inverseStereo(z[i]);
	V[4]=IntervalVector.northPole();

	Interval total=new Interval(0.0);
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		total=Interval.plus(total,interaction(e,V[i],V[j]));
	    }
	}
	return(total);
    }

    public static Interval energy(int[][] E,GaussianInteger[] z) {
	Interval tot=new Interval(0.0);
	for(int i=0;i<3;++i) {
	    if(E[i][0]!=0) {
	       Interval coeff=Interval.fat(1.0*E[i][0]);
               tot=Interval.plus(tot,Interval.times(coeff,energy(E[i][1],z)));
	    }
	}
	return tot;
    }


}


