import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class PictureCanvas extends ScaleCanvas implements  KeyListener, MouseListener, MouseMotionListener {
    Manager M;   
    Complex[] Z=new Complex[4];    //the displayed configuration
    ListenSquare CONTROL,WORDS,SUB;
    SelectInteger GRID,SCALE;
    ControlPanel SHOW;
    ListenSquare[] FOCUS=new ListenSquare[5];
    int VIEW;
    SubdivisionControl SC;
    Point JX;
    ListenSquare TBP;
    ListenSquare INFO1;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);	 
         addKeyListener(this);
	 setScales(275,275,180);	
	 Z=Configuration.configuration2();
	 double a=Math.sqrt(-1);
	 CONTROL=new ListenSquare(0,0,549,60);
	 WORDS=new ListenSquare(0,340,399,59);
	 SUB=new ListenSquare(0,0,60,399);
	 VIEW=4;
	 FOCUS[0]=new ListenSquare(220,20,20,20);
	 FOCUS[1]=new ListenSquare(200,40,20,20);
	 FOCUS[2]=new ListenSquare(180,20,20,20);
	 FOCUS[3]=new ListenSquare(200,0,20,20);
	 FOCUS[4]=new ListenSquare(5,5,25,25);
	 SCALE=new SelectInteger(45,20,40,20,4,1,16,1);
	 GRID=new SelectInteger(250,5,40,20,4,1,5,1);
	 JX=new Point();
	 SC=new SubdivisionControl(0,60);
	 TBP=new ListenSquare(100,45,15,15);
	 INFO1=new ListenSquare(0,60,12,12);
	 setPanels();
     }

    public void setPanels() {

	Color[] C0={new Color(255,130,0),Color.white,Color.white,Color.black,Color.red};
        String[] Show1String={"TBP edges","TBP neighborhood","display"};
        int[] Show1State={1,0};
        SHOW=new ControlPanel(C0,Show1String,Show1State,2);
    }




   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawFrame(g);     
      GridDrawer.drawGrid(this,g,GRID.val);
      GridDrawer.drawDiamond(this,g); 
      drawBlock(g);
      drawSubdivisionControl(g);
      drawWords(g);  
      drawZone(g);
      drawControls(g);
   }


    public void drawSubdivisionControl(Graphics2D g) {
	SUB.h=this.getHeight();
	SUB.render(g,new Color(0,0,0));
	SC.render(g);
	INFO1.infoRender(g);
    }

    /**This is the frame**/

    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(0,0,250));
	Color C=new Color(0,0,150);
	g.fillRect(0,0,getWidth(),getHeight());
	drawRectangle(g,C,new Color(0,0,255),-2,-2,2,2);
	drawRectangle(g,new Color(0,0,0),new Color(0,0,255),-1.5,-1.5,1.5,1.5);
	drawRectangle(g,new Color(0,0,0),new Color(0,0,200),1,-.25,4,.25);
	g.setColor(new Color(0,255,255,80));
	Path2D.Double CIRCLE=GridDrawer.unitCircle();
	CIRCLE=transform(CIRCLE);
	g.draw(CIRCLE);
    }

    public void drawWords(Graphics2D g) {
	WORDS.y=getHeight()-65;
	WORDS.w=getWidth()-1;
	WORDS.render(g,new Color(40,0,40));
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.drawString("mouse buttons: zxc  or  bnm",135,getHeight()-30);
    }


    public void drawControls(Graphics2D g) {

	CONTROL.render(g,new Color(80,0,0));
	GRID.render(g,new Color(255,120,0),Color.white,Color.white);
	SCALE.render(g,Color.blue,Color.white,Color.white);
	g.drawString("grid detail",(int)(GRID.x+2),(int)(GRID.y+32));
	g.drawString("zoom scale",(int)(SCALE.x+2),(int)(SCALE.y+32));
	Color[] C={new Color(0,255,0),Color.magenta,Color.red,Color.orange,Color.blue};
	for(int i=0;i<5;++i) {
	    FOCUS[i].render(g,C[i]);
	}

	Color[] COL=Configuration.colors();
	int choice=SC.choice;
	g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("reset",5,42);
	g.drawString("view",5,55);
	g.drawString("click these",115,18);
	g.drawString("to zoom in",115,33);
	g.drawString("near TBP",115,49);
    }

    /**Here are the points. The sizes come from the
       numbers on the configurastion control*/

    public Block getBlock() {
       	Block BOX=convert(Z,SC.size);
       	return(BOX);
    }


    /**converts a list of complex numbers to boxes**/

  public static Block convert(Complex[] Z,int[] k) {	
        Block BOX=new Block();
	for(int i=0;i<4;++i) {
	    BOX.B[i]=new Box();
	    BOX.B[i].z=new Complex(Z[i]);
	    BOX.B[i].k=k[i];
	    BOX.B[i].type=0;
	    BOX.B[i].g=GaussianInteger.convert(Z[i],Box.SCALE);
	}

	BOX.B[0].type=1;
	BOX.B[4]=new Box(new Complex(0,0),0,2);
	return(BOX);
    }



    public void drawBlock(Graphics2D g) {
	Color[] C = Configuration.colors();
	makeDyadic();
	Block B=getBlock();
	drawBlock(g,B,C,1);
    }

    public void drawBlock(Graphics2D g,Block X,Color[] C,int fill) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<4;++i) {
	    gp=X.B[i].toPath();
	    g.setColor(C[i]);
	    if(i==0) g.setStroke(new BasicStroke(5));
            gp=transform(gp);
 	    g.draw(gp);
 	    g.fill(gp);
	    g.setStroke(new BasicStroke(1));
	}
	g.setStroke(new BasicStroke(1));
	gp.reset();
	gp.moveTo(X.B[0].z.x,X.B[0].z.y);
	gp.lineTo(X.B[1].z.x,X.B[1].z.y);
	gp.lineTo(X.B[2].z.x,X.B[2].z.y);
	gp.lineTo(X.B[3].z.x,X.B[3].z.y);
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.orange);
	g.draw(gp);
    }


    /**Here are the basins around the minimal configurations.*/

    public void drawZone(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();

	gp.moveTo(27.0/32,1.0/64);
	gp.lineTo(63.0/64,1.0/64);
	gp.lineTo(63.0/64,-1.0/64);
	gp.lineTo(27.0/32,-1.0/64);
	gp.closePath();

	gp.moveTo(-1.0/32,-21.0/32);
	gp.lineTo(-1.0/32,-29.0/32);
	gp.lineTo(+1.0/32,-29.0/32);
	gp.lineTo(+1.0/32,-21.0/32);
	gp.closePath();

	gp.moveTo(-25.0/32,+3.0/64);
	gp.lineTo(-25.0/32,-3.0/64);
	gp.lineTo(-63.0/64,-3.0/64);
	gp.lineTo(-63.0/64,+3.0/64);
	gp.closePath();

	gp.moveTo(-1.0/32,21.0/32);
	gp.lineTo(-1.0/32,29.0/32);
	gp.lineTo(+1.0/32,29.0/32);
	gp.lineTo(+1.0/32,21.0/32);
	gp.closePath();

	gp=transform(gp);
	g.setColor(Color.yellow);
	g.draw(gp);
    }


    public void doControls(Point X) {
	SCALE.modify(X);
	GRID.modify(X);
	SHOW.toggle(X);
	setViews(X);
    }


    /**This zooms in on one of the 4 areas near the TBP,
       or else zooms out to show the whole thing*/
    public void setViews(Point X) {
	VIEW=-1;

	for(int i=0;i<5;++i) {
	    if(FOCUS[i].inside(X)==1) VIEW=i;
	}

	for(int i=0;i<4;++i) {
 	   int k=SCALE.val;    
	   double d=Math.pow(.5,k+1);
	   Complex[] W=Configuration.configuration2();
	   if((VIEW!=-1)&&(VIEW<4)) {
              Path2D.Double gp=getSquare(W[VIEW],d);
	      scaleNicely(gp);
	   }
	}
	if(VIEW==4) {
	    Path2D.Double gp=getSquare(new Complex(0,0),3);
            scaleNicely(gp);
	}

	System.out.println(VIEW);

    }




    /**Select the position of the dyadic box using the mouse*/

    public void selectDyadicSquare() {
	int choice=SC.choice;
	int k=SC.size[choice];

	if(choice==0) {
	    if((SOURCE.x>0)&&(SOURCE.x<4)) {
	       Z[choice]=SOURCE.makeDyadic(k);
	       Z[choice].y=0;
	    }
	}

	if(choice!=0) {
	    if((SOURCE.x>-2)&&(SOURCE.x<2)&&(SOURCE.y>-2)&&(SOURCE.y<2)) {
	       Z[choice]=SOURCE.makeDyadic(k);
	    }
	}
    }







    /**This makes a box configuration dyadic.*/

    public void makeDyadic() {
	for(int i=0;i<4;++i) Z[i]=Z[i].makeDyadic(SC.size[i]);
	Z[0].y=0;
    }

    /**Switches the dyadic square under control*/

    public void switchSquare() {
	int a=SC.choice;
	a=(a+1)%4;
	SC.choice=a;
    }

    /**Chances the square size*/
    public void changeSquareSize(int k) {
	int b=SC.choice;
	int a=SC.size[b];
	a=a+k;
	if(a<0) a=0;
	if(a>26) a=26;
	SC.size[b]=a;
    }


    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) {  
      MouseData J=MouseData.process(e);
      doMouseClick(J.mode,J.X);
    }

    public void documentStuff(Point X) {
	if(SHOW.L[20].inside(X)==1) DocumentBlock.display(M.D);
	if(INFO1.inside(X)==1) DocumentBlock.block(M.D);
    }

    public void doMouseClick(int mode,Point X) {
	boolean test=false;
	documentStuff(X);
	if(CONTROL.inside(X)==1) {
               doControls(X);	  
	       test=true;
	}
	if(SUB.inside(X)==1) {
	    SC.process(X,this);
            test=true;
	}

	if(test==false) {
	   if(mode==2) {
	      SOURCE=unTransform(X);
	      selectDyadicSquare();
	   }  
           if(mode==3) scaleUp(X,1);
	   if(mode==1) scaleUp(X,-1);
	}

	doTest();
        M.repaint();
    }

    public void doTest1() {

    }



    public void doTest() {

	Block X=getBlock();
	System.out.println("----");
	boolean test=EliminateDebug.main(X);
	System.out.println("debug    "+test+"    ");
	test=EliminateNearTBP.main(X);
	System.out.println("near TBP  "+test+"    ");
	test=EliminateNearFP.main(X);
	System.out.println("near FP   "+test+"    ");
	test=EliminatePermuted.main(X);
	System.out.println("permuted   "+test+"    ");

    }




     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
	 M.repaint();
     }

     public void mouseExited(MouseEvent e) {
	 M.repaint();
     }

    public void mouseMoved(MouseEvent e) { 
         MouseData J=MouseData.process(e);
	 JX=J.X;
    }

    public void mouseDragged(MouseEvent e) {}



    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int mode=0;
	if(ch=='z') mode=1;
	if(ch=='x') mode=2;
	if(ch=='c') mode=3;
	if(ch=='b') mode=1;
	if(ch=='n') mode=2;
	if(ch=='m') mode=3;
	if(ch=='a') switchSquare();
	if(ch=='l') switchSquare();
	if(ch=='q') changeSquareSize(-1);
	if(ch=='w') changeSquareSize(+1);
	if(ch=='o') changeSquareSize(-1);
	if(ch=='p') changeSquareSize(+1);

	if(mode>0) doMouseClick(mode,JX);
	M.repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

