import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**The manager lets the program communicate with
   the main windows.  
   The HALT variable says whether the program is running.
   LIST is the list of configurations
   COUNT is the length of the list
   PASSED keeps track of the number passed;
   TOTAL keeps track of the volume of blocks passed.*/
   

public class Proof implements Runnable {
    Manager M;
    boolean HALT;
    Block[] LIST=new Block[300];
    int COUNT;
    int MAXCOUNT;
    long TIME;
    long PASSED;
    double TOTAL;
    int MAXDEPTH;
    int[] LOG=new int[300];
    int[] CURRENTDEPTH=new int[4];

    public Proof() {
	HALT=true;
    }

    /**This is the construction method for the program*/

    public Proof(Manager MM) {
	this.M=MM;
	setParameters();
	HALT=true;
	COUNT=1;
	TOTAL=0;
	PASSED=0;
        LIST[0]=Block.initialBox();
	for(int i=0;i<200;++i) LOG[i]=0;		
    }


    /**This sets the subdivision depth and the the TBP tolerance*/
    public void setParameters() {
	if(M.C.SIMPLE.mode==0) {
	    Box.SCALE=25;
	    Box.TOL=15;
	}
	else {
	    Box.SCALE=M.C.SCALE.getVal();
	    Box.TOL=M.C.TOL.getVal();
	}
    }


    /**This is what runs when the program is started*/

    public static int[][] getEnergy(Manager M) {
	if(M.C.SIMPLE.mode==0) {
	    int[][] E={{1,M.C.ENERGY1.val},{0,1},{0,1}};
	    return E;
	}
	int[][] E=new int[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		E[i][j]=M.C.ENERGY[i][j].getVal();
	    }
	}
	return E;
    }

    public void checkConstraints() {
	if(Box.SCALE<5) {
	    throw new ProofException("Minimum subdivision limit allowed is 5.  This is present because the program always needs a few subdivisions to get going.");
	}
	if(Box.SCALE>40) {
	    throw new ProofException("Maximum subdivision limit allowed is 40.  This somewhat arbitrary cutoff is present to prevent roundoff error.");
	}

	if(Box.TOL<-3) {
	    throw new ProofException("Maximum TBP neighborhood is 1/2^-3, or 8.  With the choices of -2 and -3 there are no relevant configurations to check.");
	}

	if(Box.TOL>40) {
		throw new ProofException("Minimum TBP neighborhood is 2^-40.  This choice is so small that the program would never run to completion with any energy.");

	}


    }


    public void run() {
	checkConstraints();
	initialize();
	int mode=M.C.PROOFMODE.mode;
	int[][] E=getEnergy(M);


 	while((HALT==false)&&(COUNT>0)) {
	    delay(M.C.SPEED.val);
	    mainStep(mode,E);
	}
	sendMessage();
	HALT=true;
    }

    public void delay(int k) {
	if(k==0) return;
	double d=1000*Math.pow(2,k)/Math.pow(2,20);
	long a=System.currentTimeMillis();
	boolean test=false;
	while(test==false) {
	    long b=System.currentTimeMillis();
	    if(b-a>d) test=true;
	}
    }

    public void initialize() throws ProofException {
	HALT=false;
	TIME=System.currentTimeMillis();
	sendMessage();
    }

    /**The main step in the algorithm.*/

    public void mainStep(int mode,int[][] E) {   
 	 int[] test={0,0};
         Block X=new Block(LIST[COUNT-1]);
	 boolean rigor=false;
	 if(mode==1) rigor=true;
	 test=ProofGrading.main(rigor,E,X);
	 if(test[0]==0)  subdivide(X,test[1]);
	 if(test[0]==1)  eliminate(X);  
	 if(MAXCOUNT<COUNT) MAXCOUNT=COUNT;
         displayTime();
    }

    /** elimination: we display the eliminated block
        on the picture window*/

    public void eliminate(Block X) {
	--COUNT;
	++LOG[14+X.volumeLog()];  
        for(int i=0;i<4;++i) CURRENTDEPTH[i]=X.B[i].k;
	int depth=X.maxDepth();
	if(MAXDEPTH<depth) MAXDEPTH=depth;
	++PASSED;
	displayPassedBlock(X);
    }

    /**Subdivision: The integer q tells which subdivision to perform.**/

    public void  subdivide(Block X,int q) {	
	--COUNT;
	if(q==0) {
	   for(int n=0;n<2;++n) {
	      LIST[COUNT]=X.subdivide1(n);
	      ++COUNT;
	   }
	}

	if(q!=0) {
	  for(int n=0;n<4;++n) {
	  LIST[COUNT]=X.subdivide0(q,n);
	  ++COUNT;
	  }
	}
    }


    /**These routines aren't part of the proof, but they are used to 
       mark the progress of the program.**/

    public void displayTime() {
	 double[] time=new double[10];
         double tt=System.currentTimeMillis()-TIME;
	 sendMessage();
    }


    /**The message sent to the main window*/

    public void sendMessage() {
	computeVolume();
	String T=Time.convert(System.currentTimeMillis()-TIME);
	M.C.PC.time=T;
	M.C.PC.VOLUME=TOTAL;   //volume eliminated
	M.C.PC.PASSED=PASSED;
	M.C.PC.K=0;
	M.C.PC.MODE=0;
	M.C.PC.MAXDEPTH=MAXDEPTH;
	M.C.PC.CURRENTDEPTH=CURRENTDEPTH;
	M.C.PC.LENGTH=COUNT;
	M.C.PC.MAXLENGTH=MAXCOUNT;
	M.repaint();
    }


    public void computeVolume() {
         double total=0;
	 for(int i=0;i<200;++i) {
	   total=total+LOG[i]*Math.pow(.5,i);
	 } 
         TOTAL=total;
    }


    public void displayPassedBlock(Block X) {
	try{
	   M.P.Z=Block.centerDisplay(X);
	   for(int i=0;i<4;++i) M.P.SC.size[i]=X.B[i].k;
	   M.repaint();
	}
	catch(Exception e) {}
    }


 


}


