import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class does the basic arithmetic of complex numbers */

public class Symmetrize implements Runnable {
    boolean HALT;

    public Symmetrize() {
	HALT=true;
    }


    public void run() {
	HALT=false;
	double min=100;
	long count=0;
	long count2=0;
	while(HALT==false) {
	   double test=Symmetrize.doTest();
	   if(count==1000000) {
                 System.out.println(count2+" million: min="+min);
		 count=0;
		 ++count2;
	   }
	   ++count;
	   if(min>test) min=test;
	}
	System.out.println("done");
    }


    public static double doTest() {
	int k=(int)(2+13*Math.random());
	int[][] e={{1,k},{0,1},{0,1}};
	return doTest(e);
    }

    public static double doTest(int[][] e) {
	Complex[] z=RandomGenerator.randomConfig();
	Complex[] w=symm(z);
	w=symm2(w);
	double test1=Energy.energy(e,z);
	double test2=Energy.energy(e,w);
	double test=test1/test2; 
	if(test<1) System.out.println("exp "+e[0][1]);
	return test;
    }

    public static Vector[] toVector(Complex[] z) {
	Vector[] V=new Vector[5];
	for(int i=0;i<4;++i) V[i]=Vector.inverseStereo(z[i]);
	V[4]=new Vector(0,0,1);
	return V;
    }


    public static Complex[] symm(Complex[] z) {
	Complex[] w=new Complex[4];
	for(int i=0;i<4;++i) w[i]=new Complex();
	w[0].x=(z[0].x-z[2].x)/2;
	w[0].y=(z[0].y-z[2].y)/2;
	w[1].x=(z[1].x-z[3].x)/2;
	w[1].y=(z[1].y-z[3].y)/2;
	w[2]=new Complex(-w[0].x,-w[0].y);
	w[3]=new Complex(-w[1].x,-w[1].y);
	Complex u=w[0].toUnit();
	for(int i=0;i<4;++i) w[i]=Complex.divide(w[i],u);
	return w;
    }


    public static Complex[] symm2(Complex[] z) {
	Complex[] w=new Complex[4];
	w[0]=new Complex(z[0]);
	w[2]=new Complex(z[2]);
	w[1]=new Complex(0,-z[1].norm());
	w[3]=new Complex(0,+z[3].norm());
	return w;
    }


}


    
