import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener, KeyListener {
    AffineTransform A;
    Manager M;
    HSlider EXP;
    EnergyCombo[] ENG=new EnergyCombo[5];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 Color[] C1={new Color(200,0,0),Color.white,Color.white};
	 Color[] C2={new Color(0,0,200),Color.white,Color.white};
	 EXP=new HSlider(0,0,480,30,250,C1,"exponent");
	 int[] p={50,100,200,300};
	 String[] S={"0","1","2","4","8"};
	 for(int i=0;i<5;++i) ENG[i]=new EnergyCombo(35+35*i,S[i]);
    }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
      drawControls(g);
   }
    
    public void drawControls(Graphics2D g) {
	g.setColor(new Color(20,30,40));
	g.fillRect(0,0,getWidth(),getHeight());
	EXP.render(g);
	double d=EXP.getValue();
	d=-2*(1-d)+16*d;
	Double D=new Double(d);
	g.setColor(Color.white);  
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString(D.toString(),70,28);
	for(int i=0;i<5;++i) ENG[i].render(g);
    }


    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	for(int i=0;i<5;++i) ENG[i].process(e);
	EXP.modify(J.X);
	M.repaint();
    }



    public double getExponent() {
	double d=EXP.getValue();
	double e=-2*(1-d)+16*d;
	return e;
    }


    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	EXP.modify(J.X);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   






    public void keyTyped(KeyEvent e) {
	for(int i=0;i<5;++i) ENG[i].processKey(e);
	repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

