import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**This class does matrix algebra for up to 10x10 cases.*/

public class Matrix {
    double[][] m=new double[10][10];
    int size; 
    int[] data=new int[2];  //for Gaussian elimination



    public Matrix() {}


    public Matrix(Matrix m) {
	this.size=m.size;
	this.data=m.data;
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		this.m[i][j]=m.m[i][j];
	    }
	}
    }


    public void print() {
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		System.out.print(m[i][j]+" ");
	    }
	    System.out.println("");
	}
    }


    public static Matrix identity(int s) {
	Matrix M=new Matrix();
	M.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		M.m[i][j]=0;
		if(i==j) M.m[i][j]=1;
	    }
	}
	return(M);
    }

    /* adds 2 vectors*/

    public static double[] plus(double[] r,double[] s) {
	int N=r.length;
	double[] t=new double[N];
	for(int i=0;i<N;++i) t[i]=r[i]+s[i];
	return(t);
    }

    /*subtracts 2 vectors*/

    public static double[] minus(double[] r,double[] s) {
	int N=r.length;
	double[] t=new double[N];
	for(int i=0;i<N;++i) t[i]=r[i]-s[i];
	return(t);
    }

    /*scales a vector*/

    public static double[] scale(double m,double[] r) {
	int N=r.length;
	double[] t=new double[N];
	for(int i=0;i<N;++i) t[i]=m*r[i];
	return(t);
    }

    /**Matrix multiplication*/

    public static Matrix times(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	M.size=M1.size;
	for(int i=0;i<M.size;++i) {
	    for(int j=0;j<M.size;++j) {
		double total=0;
		for(int k=0;k<M.size;++k) {
		    total=total+M1.m[i][k]*M2.m[k][j];
		}
		M.m[i][j]=total;
	    }
	}
	return(M);
    }

    /*Matrix transpose*/

    public Matrix transpose() {
	Matrix M=new Matrix();
	M.size=this.size;
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		M.m[j][i]=this.m[i][j];
	    }
	}
	return(M);
    }

    /*inverse*/
    public static Matrix inverse(Matrix m) {
	Matrix[] M=new Matrix[2];
	M[0]=new Matrix(m);
	M[0].data[0]=0;
	M[0].data[1]=0;
	M[1]=identity(m.size);
	for(int i=0;i<m.size;++i) {
           M=GaussianElimination.step(M);
	}
	if(M==null) return(null); //singular matrix
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		M[1].m[i][j]=M[1].m[i][j]/M[0].m[i][i];
	    }
	}
	return(M[1]);
    }

    public static double det(Matrix M) {
	Matrix m=new Matrix(M);
	m.data[0]=0;
	m.data[1]=0;
	for(int i=0;i<m.size;++i) m=GaussianElimination.step(m);
	double d=1;
	for(int i=0;i<m.size;++i) d=d*m.m[i][i];
	if(m.data[1]%2==1) d=-d;
	return(d);
    }


    /*the zero row.  This routine isn't strictly necessary because
      Java initializes arrays to 0.  However, it is good to have it
      explicitly for the sake of code readability.*/


    public static double[] zeroRow(int N) {
	double[] r=new double[N];
	for(int i=0;i<N;++i) r[i]=0;
	return(r);
    }

    /**a random matrix*/

    public static Matrix random(int s) {
	Matrix m=new Matrix();
	m.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		m.m[i][j]=Math.random();
	    }
	}
	return(m);
    }

}
