import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Parameter {
    int x,y;
    ListenSquare MAIN,TEXT;
    boolean ACTIVE;
    Color COLOR;
    String S;

    public Parameter(int xx,int yy,String s) {
	this.x=xx;
	this.y=yy;
	this.S=s;
	TEXT=new ListenSquare(x,y,80,20);
	COLOR=Color.blue;
	MAIN=new ListenSquare(x,y,80,20);
	ACTIVE=false;
    }

    public String toString(int a,int b) {
	Integer A=new Integer(a);
	Integer B=new Integer(b);
	String S=A.toString()+"/"+B.toString();
	return(S);
    }

    public void render(Graphics2D g) {	
        drawBG(g);
	int p=getNumerator();
	int q=getDenominator();
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString(S,x+5,y+15);
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.blue);
	g.fillRect(x,y,80,20);
	g.setColor(Color.white);
	g.drawRect(x,y,80,20);
    }

    public void activate(Point X) {
	ACTIVE=false;
	if(TEXT.inside(X)==1) ACTIVE=true;
    }

    public int[] interpretFraction() {
	return(interpretFraction(S));
    }

    public int[] interpretFraction(String U0) {
	int k0=U0.indexOf("-");
	String U=new String(U0);
	int sign=1;
	if(k0!=-1) {
	    sign=-1;
	    U=U.substring(1,U.length());
	}
	int k=U.indexOf("/");
	if(k==-1) {
	    U=U.replace(" ","");
	    Integer I=new Integer(U);
	    int[] a={I.intValue(),1};
	    return(a);
	}
	String T1=U.substring(0,k);
	String T2=U.substring(k+1,U.length());
	Integer I1=new Integer(T1);
	Integer I2=new Integer(T2);
	int[] I={sign*I1.intValue(),I2.intValue()};
	return(I);
    }

    public boolean acceptFraction(int[] b) {
	long[] c={b[0],b[1]};
	acceptFraction(c);
	return(true);
    }

    public boolean acceptFraction(long[] b) {
	if(b[0]<=0) return(false);
	if(b[1]<=0) return(false);
	Long b0=new Long(b[0]);
	Long b1=new Long(b[1]);
	S=b0.toString()+"/"+b1.toString();
	return(true);
    }

    public double getVal() {
	int[] a=getFraction();
	return 1.0*a[0]/a[1];
    }

    public int getNumerator() {
	int[] a=getFraction();
	return(a[0]);
    }

    public int getDenominator() {
	int[] a=getFraction();
	return(a[1]);
    }

    public int[] getFraction() {
	int[] a={1,2};
	try {
	   a=interpretFraction();
	}
	catch(Exception e) {}
	return(a);
    }



    /*testing whether the selector is used*/

    public boolean inside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(MAIN.inside(J.X)==1) return(true);
	return(false);
    }

    public boolean inside(Point X) {
	if(MAIN.inside(X)==1) return(true);
	return(false);
    }

    public void process(MouseEvent e) {
	MouseData J=MouseData.process(e);
	activate(J.X);
    }

    public boolean processKey(KeyEvent e) {
	if(ACTIVE==false) return(false);
	int n=S.length();

	char ch=e.getKeyChar();

        if(isDigit(ch)==true) S=S+ch;

	int val=0;
	val=(int)(ch-'/');
	if(val==0) S=S+"/";

	val=(int)(ch-' ');
	if(val==0) S=S+" ";


        if (ch==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

        if (ch==KeyEvent.VK_DELETE) {
            S="1/2";
        }

	if(ch=='-') {
 	  int k=S.indexOf("-");
	  if(k==-1) S="-"+S;
	  else S=S.substring(1,S.length());
	}




	if(S.length()>50) S=S.substring(0,n-1);
	return(true);

    }

    public boolean isDigit(char ch) {
        int val=(int)(ch-'0');
        if ((val>=0)&&(val<=9)) {
	    return(true);
	}
	return(false);
    }


}





