import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class PictureCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;  
    Parameter SCALE; 
    ListenSquare BLOCK;

     public PictureCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);	 
	 setScales(20,220,160);
	 SCALE=new Parameter(10,10,"1");
	 BLOCK=new ListenSquare(0,0,400,40);

     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawFrame(g); 
      drawPlot(g); 
      drawControls(g);
   }

    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(0,0,50));
	g.fillRect(0,0,getWidth(),getHeight());
	g.setColor(Color.black);
	g.fillRect(0,0,400,300);
	g.setColor(Color.white);
	g.drawRect(0,0,400,300);

	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-10,0);
	gp.lineTo(10,0);
	gp.moveTo(0,-10);
	gp.lineTo(0,10);
	gp=transform(gp);
	g.setColor(new Color(50,100,255));
	g.draw(gp);
	gp.reset();
	gp.moveTo(Math.sqrt(2),-10);
	gp.lineTo(Math.sqrt(2),10);
	gp.moveTo(Math.sqrt(3),-10);
	gp.lineTo(Math.sqrt(3),10);
	gp.moveTo(2,-10);
	gp.lineTo(2,10);
	gp=transform(gp);
	g.setColor(new Color(0,100,100));	
        g.draw(gp);


    }


    public void drawPlot(Graphics2D g) {
	double s=SCALE.getVal();
	EnergyCombo[] d=M.C.ENG;
	double ex=M.C.getExponent();

	double[] e=SpecialFunctions.coeffList(d,ex);
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<=1700;++i) {
	    double x=1.3+1.0*i/1000;
	    double y1=SpecialFunctions.R(ex,x);
	    double y2=SpecialFunctions.cone(e,d,x);
	    double y=y1-y2;
	    y=s*y;
	    if(i==0) gp.moveTo(x,y*400);
	    if(i>0) gp.lineTo(x,y*400);
	}
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public void drawControls(Graphics2D g) {
        BLOCK.render(g,new Color(0,0,150));
	SCALE.render(g);
    }


    public void mousePressed(MouseEvent e) { }


    public void mouseClicked(MouseEvent e) {  
       MouseData J=MouseData.process(e);
       SCALE.process(e);
       if(BLOCK.inside(J.X)!=1) {
         if(J.mode==3) scaleUp(J.X,1);
         if(J.mode==1) scaleUp(J.X,-1);
       }
       M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
     }

     public void mouseExited(MouseEvent e) {
     }

    public void mouseMoved(MouseEvent e) { 
    }

    public void mouseDragged(MouseEvent e) {}


    public void keyTyped(KeyEvent e) { 
	SCALE.processKey(e);
	repaint();
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

