import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;



public class SpecialFunctions {



    /**Here is the combo potential*/

    public static double G(EnergyCombo E,double x) {
	double[][] K=new double[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		K[i][j]=E.E[i][j].getVal();
	    }
	}
	return G(K,x);
    }


    public static double dG(EnergyCombo E,double x) {
	double[][] K=new double[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		K[i][j]=E.E[i][j].getVal();
	    }
	}
	return dG(K,x);
    }


    public static double G(double[][] K,double x) {
	double tot=0;
	for(int i=0;i<3;++i) tot=tot+K[i][0]*G(K[i][1],x);
	return tot;
    }

    /**Here is the combo derivative*/
    public static double dG(double[][] K,double x) {
	double tot=0;
	for(int i=0;i<3;++i) tot=tot+K[i][0]*dG(K[i][1],x);
	return tot;
    }

    /**Here is the Tumanov potential - the main
       potential from the paper.*/

    public static double G(double k,double x) {
	return Math.pow(4-x*x,k);
    }

    /**Here is the derivative of the potential*/

    public static double dG(double k,double x) {
	return -2*k*x*Math.pow(4-x*x,k-1);
    }


    /**Here is the Riesz power law potential*/

    public static double R(double s,double x) {
	double a=1;
	if(s<0) a=-1;
	return a*Math.pow(x,-s);
    }

    /**Here is the derivative of the Riesz potential*/
    public static double dR(double s,double x) {
	double a=1;
	if(s<0) a=-1;
	return -s*a*Math.pow(x,-s-1);
    }



    /**These are the routines used in solving the
       interpolation problem*/

    public static double[] getTarget(double s) {
	double a2=Math.sqrt(2);
	double a3=Math.sqrt(3);
	double a4=2;
	double[] T={R(s,a2),R(s,a3),R(s,a4),dR(s,a2),dR(s,a3)};
	return T;
    }


    /**This is the main routine.  It gets the coefficients
       a0,a1,a2,a3,a4 of the interpolation*/

    public static double[] coeffList(EnergyCombo[] d,double s) {
	Matrix M=new Matrix();
	M.size=5;
	double a2=Math.sqrt(2);
	double a3=Math.sqrt(3);
	double a4=2;
	for(int i=0;i<5;++i) {
	    M.m[i][0]=G(d[i],a2);
	    M.m[i][1]=G(d[i],a3);
	    M.m[i][2]=G(d[i],a4);
	    M.m[i][3]=dG(d[i],a2);
	    M.m[i][4]=dG(d[i],a3);
	}
	M=Matrix.inverse(M);
	double[] T=getTarget(s);
	double[] e=new double[5];
	for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
		e[i]=e[i]+M.m[j][i]*T[j];
	    }
	}
	return e;
    }


    /**This gets the value of the linear combination*/

    public static double cone(double[] a,EnergyCombo[] b,double x) {
	double t=0;
	for(int i=0;i<5;++i) t=t+a[i]*G(b[i],x);
	return t;
    }

}



