import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class BigVector {
    BigInteger[] x=new BigInteger[2];

    public BigVector() {}

    public BigVector(BigInteger w0,BigInteger w1) {
	x[0]=new BigInteger(w0.toString());
	x[1]=new BigInteger(w1.toString());
    }

    public BigVector(BigVector V) {
	x[0]=new BigInteger(V.x[0].toString());
	x[1]=new BigInteger(V.x[1].toString());
    }

    public BigVector(int a,int b) {
        x[0]=copy(a);
	x[1]=copy(b);
    }

    public BigVector scale(BigInteger d) {
	BigVector V=new BigVector();
	V.x[0]=x[0].multiply(d);
	V.x[1]=x[1].multiply(d);
	return V;
    }

    public static BigVector add(BigVector A,BigVector B) {
	BigVector V=new BigVector();
	V.x[0]=A.x[0].add(B.x[0]);
	V.x[1]=A.x[1].add(B.x[1]);
	return V;
    }
    public static BigVector subtract(BigVector A,BigVector B) {
	BigVector V=new BigVector();
	V.x[0]=A.x[0].subtract(B.x[0]);
	V.x[1]=A.x[1].subtract(B.x[1]);
	return V;
    }

    /**This divides by a unit in the ring Z[1/p]*/

    public BigVector divideByUnits(int p) {
	BigInteger I=x[0].gcd(x[1]);
	I=removeFactors(I,p);
	BigInteger x0=x[0].divide(I);
	BigInteger x1=x[1].divide(I);
	BigVector X=new BigVector(x0,x1);
	return X;
    }

    /**factors out the highest possible power of p*/

    public static BigInteger removeFactors(BigInteger X,int p) {
	BigInteger Y=new BigInteger(X.toString());
	BigInteger P=copy(p);
	boolean test=false;
	int count=0;
	while(test==false) {
	    BigInteger G=Y.gcd(P);
	    if(G.compareTo(P)==0) Y=Y.divide(P);
	    else test=true;
	    ++count;
	}
	return Y;
    }

    public static BigInteger copy(int p0) {
	Integer p1=new Integer(p0);
	BigInteger p2=new BigInteger(p1.toString());
	return p2;
    }



    public void print() {
	System.out.println(x[0].toString()+" "+x[1].toString());
    }



}


