import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This is used to record the positions of points when you click.
   Usually this class has more stuff in it, like complex arithmetic.*/

public class Complex {
    double x,y;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }

    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public static Complex plus(Complex z1,Complex z2) {
	Complex w=new Complex();
	w.x=z1.x+z2.x;
	w.y=z1.y+z2.y;
	return(w);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }


    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    

    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }

    public Complex scale(double t) {
	return new Complex(t*x,t*y);
    }

    public static double dist(Complex a,Complex b) {
	Complex c=Complex.minus(a,b);
	return c.norm();
    }


    public double norm() {
	return Math.sqrt(x*x+y*y);
    }

    public void print() {
	System.out.println(x+" "+y);
    }



}

