import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;

/**This is the window where things are drawn*/

public class ControlCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Point CURSOR;
    Lever SIZE,CHAIN,HYP;
    Lever[] LEVEL=new Lever[4];
    int CHOICE;
    Animate AN;
    ListenSquare GO,STOP,RESCALE,SEND;
    SelectWord[] WORD=new SelectWord[8];
    PopupManager PM;
    ControlPanel ACTION,TREE;
    ControlPanelColor QUAD;
    SelectColor CS;


    public ControlCanvas() {
	 addMouseMotionListener(this);
	 addMouseListener(this);
	 addKeyListener(this);
	 setScales(300,450,160);
	 Color[] C={Color.red,new Color(50,80,255)};
	 SOURCE=new Complex(1,1);
	 CHAIN=new Lever(10,50,1,8);
	 HYP=new Lever(200,50,0,4);
	 RESCALE=new ListenSquare(350,5,70,25);
	 SEND=new ListenSquare(350,35,70,25);
	 GO=new ListenSquare(425,5,45,25);
	 STOP=new ListenSquare(425,35,45,25);
	 AN=new Animate();
	 for(int i=0;i<8;++i) {
	    WORD[i]=new SelectWord(20,190+25*i,305,20,"");
	 }
	 LEVEL[0]=new Lever(10,15,7,12);
	 LEVEL[1]=new Lever(200,15,5,9);

	 setPanels();
         CS=new SelectColor(0,400,340,49);
     }



    public void setPanels() {

	Color[] C0={new Color(200,0,120),Color.white,Color.white,
		    Color.white,new Color(50,140,210)};

	Color[] C1={new Color(0,140,0),Color.white,Color.white,
		    Color.white,new Color(50,140,210)};

	Color[] C2={new Color(120,140,160),Color.white,Color.white,
		    Color.white,new Color(50,140,210)};

	String[] ActionString={"backtrack demo",
                               "lattice list (p=2)",
                               "lattice list (p=3)",
                               "lattuce hulls (p=2)",
                               "lattuce hulls (p=3)",
                               "Lemma 2.4",
                               "go button action"};
	int[] ActionState={1,0,0,0,0,0};
	ACTION=new ControlPanel(C1,ActionString,ActionState,6);


	String[] TreeString={"calculate action",
                               "orbit map",
                               "tree window mode"};
	int[] TreeState={1,0};
	TREE=new ControlPanel(C0,TreeString,TreeState,2);

	Color[] COL={Color.blue,Color.red,Color.orange,Color.pink,Color.white};

	String[] QuadString={"pitch 02 (side)",
                               "pitch 64 (side)",
                               "pitch 66 (diag.)",
                               "pitch 62 (diag.)",
			        "background",
                               "tiling colors"};
	int[] QuadState={1,1,0,0,1};
	QUAD=new ControlPanelColor(C2,QuadString,QuadState,5,COL);

    }







    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      drawBG(g);
      drawControls(g);
      drawAction(g);
   }

    public void drawBG(Graphics2D g) {
       g.setColor(new Color(120,0,120));
       g.fillRect(0,0,getWidth(),getHeight());
       g.setColor(new Color(50,100,255));
       g.fillRect(0,70,340,320);
       PM.render(g);
       g.setColor(Color.white);
       g.drawRect(0,70,340,320);
       CS.render(g);
    }

    public void drawControls(Graphics2D g) {
      ACTION.render(g,350,70,120);
      TREE.render(g,350,185,120);
      QUAD.render(g,350,240,120);

      HYP.render2(g,"tiling layers",new Color(100,120,140));
      CHAIN.render2(g,"chain length",new Color(50,100,255));
      RESCALE.render(g,"reset scale",12,5,new Color(180,0,200));
      SEND.render(g,"send words",12,5,new Color(220,0,180));

      GO.render(g,"go",15,5,new Color(0,180,0));
      STOP.render(g,"stop",15,5,new Color(180,0,0));
      for(int i=0;i<CHAIN.val+1;++i) {
          WORD[i].render(g,Color.black,Color.yellow,Color.white);
      }
      g.setColor(Color.white);  
      g.setFont(new Font("Helvetica",Font.PLAIN,13));
      g.drawString("basic generators: 0 1 2 3 4 5 6 7",20,100);
      g.drawString("Long/Reid generators: a  A  b  B",20,125);
      g.drawString("commutator c=AbaB",20,150);
      g.drawString("horizontal words: b bc B Bc",20,175);

      LEVEL[0].render2(g,"2-tree render depth",Color.blue);
      LEVEL[1].render2(g,"3-tree render depth",Color.blue);
    }

    public void drawAction(Graphics2D g) { 
        Lattice L=GroupAction.getMatrixLeft(WORD[0].S);
        g.setFont(new Font("Helvetica",Font.PLAIN,13));
	g.drawString("group element",250,100);
        L.render(g,250,128,Color.yellow);
    }


    public void doControls(Point X) {
	ACTION.switchMode(X);
	TREE.switchMode(X);
	CHAIN.process(X);
	int t=HYP.process(X);
	if(t!=-1) {
	    try{M.H.updateTiling(t);}
	    catch(Exception e) {}
	}
	QUAD.process(X,CS.C);
	for(int i=0;i<2;++i) LEVEL[i].process(X);
	boolean test=false;
	if(LEVEL[0].isUsed(X)!=-1) test=true;
	if(LEVEL[1].isUsed(X)!=-1) test=true;
	if(test==false) return;
	M.P0.TREE=Tree.make(2,LEVEL[0].val);
	M.P1.TREE=Tree.make(3,LEVEL[1].val);
    }

    public void goRun() {
	int m=ACTION.mode;
	if(m==0) {
	  if(AN.HALT==false) return;
	  AN=new Animate(this.M);
	  new Thread(AN).start();
	}


	if(m==1) {
	    System.out.println("lattice list (p=2)");
            WheelTest.latticePrint(2);
	}

	if(m==2) {
	    System.out.println("lattice list (p=3)");
            WheelTest.latticePrint(3);
	}

	if(m==3) {
	    System.out.println("lattice hull list (p=2)");
            WheelTest.latticeHullPrint(2);
	}

	if(m==4) {
	    System.out.println("lattice hull list (p=3)");
            WheelTest.latticeHullPrint(3);
	}

	if(m==5) {
	    System.out.println("test 1");
            WheelTest.test0(3);
	}
    }


    public void rescale() {
	try {M.L.setScales(400,400,350);}
	catch(Exception e) {}


	int w0=M.P0.getWidth();
	int h0=M.P0.getHeight();
	int a0=(int)(Math.min(w0,h0));
        M.P0.setScales(w0/2,h0/2,a0/2-10);

	int w1=M.P1.getWidth();
	int h1=M.P1.getHeight();
	int a1=(int)(Math.min(w1,h1));
        M.P1.setScales(w1/2,h1/2,a1/2-10);

	try {
	   int w2=M.H.getWidth();
	   int h2=M.H.getHeight();
	   int a2=(int)(Math.min(w2,h2));
           M.H.setScales(w2/2,h2/2,a2/2-10);
	}
	catch(Exception e) {}

    }

    public void sendWords() {
	try{String S=M.H.WORD[0];}
	catch(Exception e) {return;}
	for(int i=0;i<8;++i) M.H.WORD[i]=new String(WORD[i].S);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}  

    /**accepts mouse clicks and rescales*/
 
    public void mouseClicked(MouseEvent e) {
	CS.process(e);
	MouseData J=MouseData.process(e);
	doControls(J.X);
	if(GO.inside(J.X)==1) goRun();
	if(STOP.inside(J.X)==1) AN.HALT=true;
	if(RESCALE.inside(J.X)==1) rescale();
	if(SEND.inside(J.X)==1) sendWords();
	for(int i=0;i<8;++i) WORD[i].activate(J.X);
	PM.process(J.X);
	M.repaint();
     }

    public void mouseDragged(MouseEvent e) {
	CS.process(e);
	M.repaint();
     }

    public void mouseMoved(MouseEvent e) {
     }

    public void doTest() {
	String S="AAaBc";
	String T=HyperbolicTile.simplify(S);
	System.out.println(S);
	System.out.println(T);
    }

    public void doMouseClick(int test) {

        if(test==1) scaleUp(CURSOR,-1);
	if(test==3) scaleUp(CURSOR,1);
	if(test==2) SOURCE=unTransform(CURSOR);
	M.repaint();
     }

    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {
	for(int i=0;i<8;++i) {
	  WORD[i].modify(e);
	}
	M.repaint();
    }

}



