import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocInstructions {

    public DocInstructions() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Serre Tree Calculator\n";
	S=S+"by Rich Schwartz\n";
	S=S+"program started: 10 March 2019\n";
	S=S+"Last updated:  25 May 2019\n";


	S=S+"\n\nPURPOSE:\n\n";
	S=S+"This program does computations for the Long-Reid group acting on the producr of 2 Serre trees. It is a companion to my paper which analyzes this action.";


	    S=S+"\n\nOPERATING INSTRUCTIONS\n\n";

	    S=S+"First, here is some information about this text window. This window gives explanations for the rest of the program.  Drag the mouse over the text to scroll up or down. There is more text than what is now visible.  You can resize this window and  also change the font size.";

	    S=S+"\n\nThis program is designed to work best with a 3 button mouse. On the picture windows, buttoms 1 and 3 zoom in and out of the picture and button 2 generally selects a new point. If you don't have a 3 button mouse, you can use the keyboard buttons z,x,c to simulate the 3 buttons when you are operating any of the windows where you might want to rescale the picture.";

	    S=S+"\n\nMAIN FEATURES";

	    S=S+"\n\nAside from this text window, the program has 5 other windows.\n\n"; 

	    S=S+"Control panel";
	    S=S+"\n\nSerre 2-tree window";
	    S=S+"\n\nSerre 3-tree window";
	    S=S+"\n\nHyperbolic window";
	    S=S+"\n\nTree Metric window";

	    S=S+"\n\nExcept for the control panel, all the windows are resizeable. However, I carefully sized them so that initially they fit together to form a big square if you lay them out just right. You kill the whole program by killing the control panel.\n\nI will explain each of the windows in turn.";


	S=S+"\n\nCONTROL PANEL:\n\n";
	S=S+"You select things in the control panel by clicking in the buttons. Here is what you can do on the control panel:";

	S=S+"\n\n2-tree render depth: This tells how much of the 2-tree to draw.";
	S=S+"\n\n3-tree render depth: This tells how much of the 3-tree to draw.";
	S=S+"\n\ntiling layers: Thus lets you specify how much of the hyperbolic geometry tiling to draw.  The second button on the left shows the central and 4 additional tiles which play a role in Lemm 2.5 in the paper.   The drawing is pretty slow at the highest level.";

	S=S+"\n\nreset scale:  This button will reset the scales on the other windows so that the picture fits nicely. It is nice to use this feature after you have resized the window.";

	S=S+"\n\nsend words: This button will sends the group elements you have used to the other windows.  Roughly speaking, if you have selected words w1,w2,w3 then the hyperbolic plane window will show the points w1(o), w2(o), w3(o) were o is the origin.  In the orbit map mode, the Serre tree windows will show the path from w1(O) w2(O) to w3(O) in each window.  This is a rough description. Precisely, you need to set the chain length to 3 to get this to work. If the chain length is set to 2, you would just see the objects corresponding to the first 2 words.";


	S=S+"\n\nWord entry fields:  You can type in words in these fields.  You can enter up to 8 words, and the number you enter is controlled by the row of buttons labeled `chain length'.  The control panel will display the matrix corresponding to the word in the top field. The other fields have a different purpose.  In one mode, the Serre tree windows will dispay the Serre action of the top word.  In the other mode, the program computes the piecewise geodesic path in each Serre tree defined by the orbit map associated to the words you have selected. \n\nThe allowable digits for the word field are\n\n1,2,3,4,5,6,7,8,a,A,b,B,c,C.\n\nHere a,A,b,B are generators for the Long-Reid group, c=AbaB and C is c_inverse.  The digits 1,2,... are the generators of a larger group and we express the Long-Reid elements in terms of these for the purposes of calculation.  The precise relation is:";
	S=S+"\n\na=35300242\nb=35366333344444444433242";


	S=S+"\n\nTree window mode:  This lets you select between the two modes of the Serre tree windows.  The background color changes depending on the mode.";

	S=S+"tiling colors: Each quad in the hyperbolic tiling has 2 edges and 2 diagonals.  We name them by their pitch under the map from the paper.  The coloring conventions are initially set as in the paper, but you can change the colors.  You can also turn on and off the display of the diagonals.  (You can't turn off the display of the edges but you could make their color transparent; I was just lazy about setting this up.)  The right column of buttons toggle the display and the right column toggles the colors. You can also change the background color for the hyperbolic plane.";

	S=S+"\n\ncolor selector:  The bottom of the window has a color selector. YOu can either select some preset colors or else change the RGB and transparency values by using the sliders.";

	S=S+"\n\nPopup window selector:  In the interest of keeping the program at least somewhat tidy, I don't have all the windows come up when the program opens. You can bring up these instructions or the hyperbolic window or the tree metric window by clicking the corresponding boxes here.  This feature is a bit delicate. If you bring up 2 hyperbolic windows, say, neither will work right. You have to kill them both and then bring up a new one.  Don't bring up the same window more than once.";

	S=S+"\n\ngo button: Starts a calculation.";

	S=S+"\n\nstop button: stops the calculation in case it is ongoing, like the limit set plot.";

	S=S+"\n\nAction selector.  Selects what the go button does.  The first option is a tool I was using when trying to prove that my map was a quasi-isometry.  This did not quite work out. If you run the backtrack demo it will compute certain geodesic segments in the translation surface and halt when it finds one whose T2 projection has 12 units of backtracking. This is not relevant to the current version of the paper but I am keeping it around for later investigations..";


	    S=S+"\n\nSERRE TREE WINDOWS";

	    S=S+"\n\nThere are two tree windows.  One shows the Serre 2-tree and the other shows the Serre 3-tree. They both work the same way.   If you wave the cursor over the window it will give you the name of the lattice you are nearest and display it in the lower left corner.  If the action mode is on, the main thing to do here is to click on a vertex. When you do this, the following happens:\n\n1. A black geodesic is drawn from the selected point L to the origin.\n\n2. The group element chosen w corresponding to the top word on the control panel is applied to the selected vertex.\n\n3. A magenta geodesic connecting the image w(L) to the origin is drawn.\n\n3.The selected point is displayed top left and its image under w is displayed top right.\n\nThe geodesics indicate the way we compute the Serre action, as described in the paper.  They serve as sanity checks that we are correctly computing what we call the full reduction of the lattice in the paper.";
	
    S=S+"\n\nHYPERBOLIC WINDOW";

    S=S+"\n\nNote: You need to open this up from the control panel. This shows several flowers of the hyperbolic quadrilateral tiling discussed in the paper. You can select up to 8 vertices using the buttons 1,2,3,4,5,6,7,8.   This feature is a bit wonky in that the window may lose focus if you move to another window. If this happens, and you want to select more vertices, you should first click in the window to return the focus.  A nice technique is to click the middle mouse button and then press the number. When you select vertices, the corresponding words are automatically sent to the control panel and recorded.  Conversely, you can select words on the control panel and then send them to the hyperbolic window.  When you select some vertices, the window draws the hyperbolic polygonal path (i.e. chain) between them.";

    S=S+"\n\nVery important technical point:  The hyperbolic plane is quasi-isometric to the infinite translation surface, but the hyperbolic geodesic connecting two vertices in the hyperbolic plane may go through different tiles than the corresponding geodesics in the translation surface. Things work fine if you confine yourself to joining vertices within a single flower.  In general, you need to consider the map between the two objects carefully to determine whether the hyperbolic geodesic path is isotopic to the translation surface geodesic via an isotopy that does not take the path through vertices. This is all about the developing map. I hope to add a feature later on that will do this automatically.";

    S=S+"\n\nAnother technical point:  If you have a hyperbolic polygon that goes through a vertex, this path locally corresponds to a geodesic if and only if the hyperbolic angle at the vertex is at least \u03C0/2.";

    S=S+"\n\nIf you put the Serre tree windows on orbit map mode, you can see the image of your vertices under the orbit map and the tree geodesics connecting them.";


    S=S+"\n\nTREE METRIC WINDOW";

    S=S+"\n\nYou should open this up whenever you are playing around with the hyperbolic window. It will show the lattices you have selected (meaning the images of your vertices under the orbit map) and the tree geodesic distances between them.  If also shows the total length of the broken geodesic path in the tree and the length of the actual tree geodesic joining the endpoints of the path.  When the numbers mismatch, there is folding going on.";


        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }





}

