import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class GroupAction {


    /**THE ACTION OF STANDARD GENERATORS*/


    /**This gives the action of words in the standard generators on chains*/

    public static Lattice[] genAction(int p,int[] word,Lattice[] B) {
	Lattice[] C=new Lattice[B.length];
	for(int i=0;i<B.length;++i) C[i]=new Lattice(B[i]);
	for(int i=0;i<word.length;++i) {
             C=genAction(p,word[i],C);
	}

	return C;
    }

    /**This is the action of the individual generators on lattice chains.
       These chains start at the identity and 
       move out to the lattice of interest, the
       last one. We keep track of the whole chain
       so that we can use the guided action routine.*/

    public static Lattice[] genAction(int p,int digit,Lattice[] B) {
	Lattice U=generator(digit);
	Lattice[] C=new Lattice[B.length];
	C[0]=generatorImage(p,digit);

	for(int j=0;j<C.length-1;++j) {
	    C[j+1]=guidedAction(p,U,B[j],C[j],B[j+1]);
	}
	Lattice[] D=Serre.fullReduce(p,C[C.length-1]);
	return D;
    }



    /**This is set up so that U(A0)=B0.  We are trying to find U(A1), and  
       we know that it must be amongst the neighbors of B0.  So we try
       them one at a time and see if we can find a match.  In practice
       the match is most likely to be with one of the expanded lattices,
       so we compute these first. We need a special addition to the routine
       when we deal with the matrix Lattice(1,0,0,9).*/

    public static Lattice guidedAction(int p,Lattice U,Lattice A0,Lattice B0,Lattice A1) {
	boolean test;
	Lattice IMAGE=U.act(A1);
	Lattice[] EXP=Serre.expand(p,B0);
	for(int i=0;i<EXP.length;++i) {
	   test=match(p,IMAGE,EXP[i]);
  	   if(test==true) return EXP[i];
	}
	Lattice RED=Serre.reduce(p,B0);
        test=match(p,IMAGE,RED);
	if(test==true) return RED;


	System.out.println("FAIL");
	IMAGE.print();
	RED.print();
	EXP[0].print();
	EXP[1].print();


	return null;
    }


    /**The basic recognition routine*/
    public static boolean match(int p,Lattice A,Lattice B0) {
	Lattice B=B0.tweak0(p);
	Lattice A0=A.tweak0(p); 
        if(Lattice.equivalent(A0,B)==true) return true;
	Lattice A1=A0.tweak1(p);
        if(Lattice.equivalent(A1,B)==true) return true;
	Lattice A2=A0.tweak2(p);
        if(Lattice.equivalent(A2,B)==true) return true;
	return false;
    }




    /**THE STANDARD GENERATORS */

    public static Lattice generator(int d) {
	if(d==0) return new Lattice(3,0,0,1);
	if(d==1) return new Lattice(1,0,0,3);
	if(d==2) return new Lattice(2,0,0,1);
	if(d==3) return new Lattice(1,0,0,2);
	if(d==4) return new Lattice(2,1,0,2);
	if(d==5) return new Lattice(2,-1,0,2);
	if(d==6) return new Lattice(2,0,1,2);
	if(d==7) return new Lattice(2,0,-1,2);
	if(d==22) return new Lattice(4,0,0,1);
	if(d==33) return new Lattice(1,0,0,4);
	if(d==66) return new Lattice(2,0,2,2);
	if(d==77) return new Lattice(2,0,-2,2);
	if(d==242) return new Lattice(4,1,0,1);
	if(d==353) return new Lattice(1,-1,0,4);
	if(d==444444444) return new Lattice(2,9,0,2);
	if(d==555555555) return new Lattice(2,-9,0,2);
	return null;
    }

    /**This records where the relevant generator maps the identity lattice.*/

    public static Lattice generatorImage(int p,int d) {
	if((p==3)&&(d==0)) return new Lattice(3,0,0,1);
	if((p==3)&&(d==1)) return new Lattice(1,0,0,3);
	//at this point, p=2
	if(p==3) return new Lattice(1,0,0,1);
	if(d==0) return new Lattice(1,0,0,1);
	if(d==1) return new Lattice(1,0,0,1);
	if(d==2) return new Lattice(2,0,0,1);
	if(d==3) return new Lattice(1,0,0,2);
	if(d==4) return new Lattice(4,0,2,1);
	if(d==5) return new Lattice(4,0,2,1);
	if(d==6) return new Lattice(2,0,1,2);
	if(d==7) return new Lattice(2,0,1,2);
	if(d==22) return new Lattice(4,0,0,1);
	if(d==33) return new Lattice(1,0,0,4);
	if(d==66) return new Lattice(1,0,0,1);
	if(d==77) return new Lattice(1,0,0,1);
	if(d==242) return new Lattice(4,0,0,1);
	if(d==353) return new Lattice(4,0,3,1);
	if(d==444444444) return new Lattice(4,0,2,1);
	if(d==555555555) return new Lattice(4,0,2,1);
	return null;
    }

    /**ALAN REID'S GROUP ACTION.
       This group is conjugated from Reid's original one
       so that a certain commutator fixeds the origin.*/

    public static Lattice[] reidAction(int p,int[] word,Lattice[] B) {
	Lattice[] C=new Lattice[B.length];
	for(int i=0;i<B.length;++i) C[i]=new Lattice(B[i]);
	for(int i=0;i<word.length;++i) C=reidAction(p,word[i],C);
	return C;
    }

    public static Lattice[] reidAction(int p,int d,Lattice[] C) {
	if(d==0) return reid_a(p,C);
	if(d==1) return reid_A(p,C);
	if(d==2) return reid_b(p,C);
	if(d==3) return reid_B(p,C);
	return null;
    }

    public static Lattice reidAction(int p,int[] word,Lattice B0) {
	Lattice[] B=Serre.fullReduce(p,B0);
	Lattice[] C=reidAction(p,word,B);
	return C[C.length-1];
    }

    /** the lattice   9  2

                      0  1  
    */
    public static Lattice[] reid_a(int p,Lattice[] B) {
	int[] word={353,0,0,242};
	return genAction(p,word,B);
    }


    /** the lattice   1  -2

                      0  9  
    */
    public static Lattice[] reid_A(int p,Lattice[] B) {
	int[] word={353,1,1,242};
	return genAction(p,word,B);
    }


    /** the lattice   0  -16

                      4  83  
    */
    public static Lattice[] reid_b(int p,Lattice[] B) {
        int[] word={353,66,33,33,444444444,33,242};
	return genAction(p,word,B);
    }


    /** the lattice   83  16

                      -4   0 
    */
    public static Lattice[] reid_B(int p,Lattice[] B) {
	int[] word={353,22,555555555,22,22,77,242};
	return genAction(p,word,B);

    }



    /** reidAction and genAction combined, using a string as input
        rather than a sequence of integers. Also, we are reversing
        the left and the right action to be consistent with what
        we are doing with the hyperbolic geometry.*/


    public static Lattice leftAction(int p,String S,Lattice B0) {
	Lattice[] B=Serre.fullReduce(p,B0);
	Lattice[] C=leftAction(p,S,B);
	return C[C.length-1];
    }


    public static Lattice[] leftAction(int p,String S,Lattice[] B) {

	Lattice[] C=new Lattice[B.length];
	for(int i=0;i<B.length;++i) C[i]=new Lattice(B[i]);

	for(int i=0;i<S.length();++i) {
            String T=S.substring(i,i+1);
	    for(int j=0;j<8;++j) {
		Integer J=new Integer(j);
		if(T.matches(J.toString())==true) C=genAction(p,j,C);
	    }
	    if(T.matches("a")==true) C=reidAction(p,0,C);
	    if(T.matches("A")==true) C=reidAction(p,1,C);
	    if(T.matches("b")==true) C=reidAction(p,2,C);
	    if(T.matches("B")==true) C=reidAction(p,3,C);

	    //some commutators added in

	    if(T.matches("c")==true) {
		int[] word={1,2,0,3};
	        C=reidAction(p,word,C);
	    }

	    if(T.matches("C")==true) {
		int[] word={2,1,3,0};
	        C=reidAction(p,word,C);
	    }

	    if(T.matches("d")==true) {
		int[] word={0,2,1,3};
	        C=reidAction(p,word,C);
	    }

	    if(T.matches("D")==true) {
		int[] word={2,0,3,1};
	        C=reidAction(p,word,C);
	    }



	}
	return C;
    }




    /**MATRIX MULTIPLICATION*/


    public static Lattice getMatrixLeft(String S) {
	Lattice L=new Lattice(1,0,0,1);
	for(int i=0;i<S.length();++i) {
            String T=S.substring(i,i+1);
	    Lattice M=new Lattice();
	    for(int j=0;j<8;++j) {
		Integer J=new Integer(j);
		if(T.matches(J.toString())==true) M=generator(j);
	    }
	    if(T.matches("a")==true) M=new Lattice(9,2,0,1);
	    if(T.matches("A")==true) M=new Lattice(1,-2,0,9);
	    if(T.matches("b")==true) M=new Lattice(0,-16,4,83);
	    if(T.matches("B")==true) M=new Lattice(83,16,-4,0);
	    if(T.matches("c")==true) M=new Lattice(-9,-2,41,9);
	    if(T.matches("C")==true) M=new Lattice(9,2,-41,-9);
	    L=M.act(L);
	}
	return L;
    }



    public static Lattice getMatrixLeft(int[] W) {
	Lattice L=new Lattice(1,0,0,1); 
        Lattice M=new Lattice();
	for(int i=0;i<W.length;++i) {
	    int w=W[i];
	    if(w==0) M=new Lattice(9,2,0,1);
	    if(w==1) M=new Lattice(1,-2,0,9);
	    if(w==2) M=new Lattice(0,-16,4,83);
	    if(w==3) M=new Lattice(83,16,-4,0);
	    L=M.act(L);
	}
	return L;
    }






}


