import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;

/**This is the window where things are drawn*/

public class HyperbolicCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener,KeyListener {
    Point CURSOR;
    Complex SHADOW=new Complex();
    String CURRENT;
    Boolean DRAG;
    Manager M;
    Complex[] PLOT=new Complex[500000];
    int COUNT;
    int[] INDEX=new int[2];
    String[] WORD=new String[10];
    HyperbolicTile[] TILE=new HyperbolicTile[400];

     public HyperbolicCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(400,400,390);
	 for(int i=0;i<10;++i) WORD[i]="";
	 initTiling();
	 CURRENT="";
     }

    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      drawBg(g);
      drawTiling(g);
      drawPoints(g); 
      g.setFont(new Font("Helvetica",Font.PLAIN,18));
      g.setColor(Color.black);
      g.drawString("use keys 1,2,3,4,5,6,7,8",10,20);
      g.drawString("to select vertices.",10,40);
   }

    public void drawBg(Graphics2D g) {
	g.setColor(new Color(180,200,220));
	g.fillRect(0,0,getWidth(),getHeight());
	fillPoint(g,new Complex(0,0),1,M.C.QUAD.M[4].C,1000);
	g.setColor(Color.black);  
    }


    public void drawTiling(Graphics2D g) {
	for(int i=0;i<COUNT;++i) {
	  TILE[i].render(this.M,g);
	}
    }

    public void initTiling() {
	TILE=HyperbolicTile.flower();
	COUNT=TILE.length;
    }

    public void updateTiling(int m) {
	TILE=HyperbolicTile.flower();
	if(m==1) TILE=HyperbolicTile.addSpecial(TILE);
	if(m==2) TILE=HyperbolicTile.grow(TILE);
	if(m==3) {
            TILE=HyperbolicTile.grow(TILE);
            TILE=HyperbolicTile.grow(TILE);
	}
	COUNT=TILE.length;
    }



    public void drawPoints(Graphics2D g) {
	for(int i=0;i<M.C.CHAIN.val+1;++i) {
            Complex z=HyperbolicGeometry.initial();
            Lattice L=GroupAction.getMatrixLeft(M.C.WORD[i].S);
	    Complex w=HyperbolicGeometry.act(L,z);
	    Complex w2=HyperbolicGeometry.transform(w);
	}

	 for(int i=0;i<M.C.CHAIN.val+1;++i) {
            Complex z=HyperbolicGeometry.initial();
            Lattice L=GroupAction.getMatrixLeft(WORD[i]);
	    Complex w=HyperbolicGeometry.act(L,z);
	    Complex w2=HyperbolicGeometry.transform(w);
	 }

	 for(int i=0;i<M.C.CHAIN.val;++i) {
	     join(g,WORD[i],WORD[i+1],Color.black,2);
	 }

        for(int i=0;i<M.C.CHAIN.val+1;++i) {
	    Complex w2=HyperbolicTile.vertexDisk(WORD[i]);
            fillPoint(g,w2,HyperbolicTile.pointRadius(w2),Color.blue,32);
	}

        fillPoint(g,SHADOW,HyperbolicTile.pointRadius(SHADOW),new Color(200,0,200),32);
        g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(Color.black);
	g.drawString(CURRENT,10,getHeight()-10);
    }

    public void join(Graphics2D g,int i,int j,Color C,int width) {
	join(g,HyperbolicTile.word(i),HyperbolicTile.word(j),C,width);
    }

    public void join(Graphics2D g,String S1,String S2,Color C,int width) {
	Path2D.Double gp=HyperbolicGeometry.join(S1,S2);
	gp=transform(gp);
	g.setColor(C);
	g.setStroke(new BasicStroke(width));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }



    public void setShadow() {
	double min=10000;
	for(int i=0;i<COUNT;++i) {
	    for(int j=0;j<4;++j) {
		String S=TILE[i].S[j];
		Complex w=TILE[i].d[j];
	        double d=Complex.dist(SOURCE,w);
	    if(d<min) {
		SHADOW=new Complex(w);
		CURRENT=TILE[i].S[j];
		min=d;
	    }}
	}

    }



    public void recognizePoint(int t) {
	double min=10000;
	String TEMP=new String();
	for(int i=0;i<COUNT;++i) {
	    for(int j=0;j<4;++j) {
		String S=TILE[i].S[j];
		Complex w=TILE[i].d[j];
	        double d=Complex.dist(SOURCE,w);
	    if(d<min) {
		min=d;
		TEMP=new String(S);
	    }
	    }
	}
	WORD[t]=new String(TEMP);
	M.C.WORD[t].S=WORD[t];
    }


    /**Mouse events*/
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	CURSOR=J.X;
	SOURCE=unTransform(J.X);
	setShadow();
	repaint();
    }

     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;

	if(mode==2) {
	    SOURCE=unTransform(J.X);
	}

	repaint();
     }

    public void mousePressed(MouseEvent e) {
    }



    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}  

    /**accepts mouse clicks and rescales*/
 
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X); 
	}
	M.repaint();
     }


    public void doMouseClick(int test) {
	if(test==1) scaleUp(CURSOR,-1);
	if(test==3) scaleUp(CURSOR,1);
	if(test==2) {
	    SOURCE=unTransform(CURSOR);
	}
	if(test>=4) {
            SOURCE=unTransform(CURSOR); 
	    recognizePoint(test-4);
	}

	M.repaint();
     }


    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') DRAG=true;
    }

    public void keyReleased(KeyEvent e) {
	DRAG=false;
    }

    public void keyTyped(KeyEvent e) {


	char ch=e.getKeyChar();
	int test=-1;
	if(ch=='z') test=1;   
	if(ch=='x') test=2;   
	if(ch=='c') test=3;  
	if(ch=='1') test=4; 
	if(ch=='2') test=5;  
	if(ch=='3') test=6; 
	if(ch=='4') test=7;
	if(ch=='5') test=8;   
	if(ch=='6') test=9; 
	if(ch=='7') test=10;
	if(ch=='8') test=11; 
	doMouseClick(test); 

	repaint();
    }





}



