import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;


/**This is used to record the positions of points when you click.
   Usually this class has more stuff in it, like complex arithmetic.*/

public class HyperbolicGeometry {


    public static Complex initial() {
	return new Complex(9.0/2,+1.0/2);
    }


    /**This maps the standard point to the unit disk*/

    public static Complex transform(Complex z) {
	Complex z1=new Complex(z.x-9.0/2,z.y);
	Complex z2=z1.scale(2);
	Complex z3=Complex.divide(new Complex(z2.x,z2.y-1),new Complex(z2.x,z2.y+1));
	return z3;
    }

    public static Complex act(Lattice L,Complex z) {
	double a=L.v[0].x[0].doubleValue();
	double b=L.v[0].x[1].doubleValue();
	double c=L.v[1].x[0].doubleValue();
	double d=L.v[1].x[1].doubleValue();
	Complex A=new Complex(a,0);
	Complex B=new Complex(b,0);
	Complex C=new Complex(c,0);
	Complex D=new Complex(d,0);
	Complex w1=Complex.plus(Complex.times(A,z),C);
	Complex w2=Complex.plus(Complex.times(B,z),D);
	Complex w=Complex.divide(w1,w2);
	return w;
    }



    public static double[] geodesic(Complex a,Complex b) {
	double x=(a.x*a.x-b.x*b.x +a.y*a.y-b.y*b.y)/(2*(a.x-b.x));
	Complex z=new Complex(x,0);
	double r=Complex.dist(z,a);
	double[] D={x,r};
	return D;
    }


    public static Path2D.Double join(String S1,String S2) {
	Complex z0=initial();
	Lattice L1=GroupAction.getMatrixLeft(S1);
	Lattice L2=GroupAction.getMatrixLeft(S2);
	Complex z1=act(L1,z0);
	Complex z2=act(L2,z0);
	return join(z1,z2);
    }

    public static Path2D.Double join(Complex z1,Complex z2) {
	double[] D=geodesic(z1,z2);
	Complex DD=new Complex(D[0],0);
	double a1=myAtan(Complex.minus(z1,DD));
	double a2=myAtan(Complex.minus(z2,DD));
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<150;++i) {
	    double t=1.0*i/150;
	    double x=(1-t)*a1+t*a2;
	    double c=D[0]+D[1]*Math.cos(x);
	    double s=D[1]*Math.sin(x);
	    Complex w=new Complex(c,s);
	    w=transform(w);
	    if(i==0) gp.moveTo(w.x,w.y);
	    if(i!=0) gp.lineTo(w.x,w.y);
	}
	return gp;
    }



    public static double myAtan(Complex z) {
	double d=Math.atan2(z.y,z.x);
	if(d<0) d=d+2*Math.PI;
	return d;
    }

    public static double hypDist(Complex z1,Complex z2) {
	double x1=z1.x;
	double y1=z1.y;
	double x2=z2.x;
	double y2=z2.y;
	double a1=Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	double a2=Math.sqrt((x2-x1)*(x2-x1)+(y2+y1)*(y2+y1));
	double a3=2*Math.sqrt(y1*y2);
	double a4=(a1+a2)/a3;
	double a5=2*Math.log(a4);
	return a5;
    }

    public static double hypDist(String S) {
	Complex z0=initial();
	Lattice L=GroupAction.getMatrixLeft(S);
	Complex z1=act(L,z0);
	return hypDist(z0,z1);
    }

    public static double hypDist(int[] S) {
	Complex z0=initial();
	Lattice L=GroupAction.getMatrixLeft(S);
	Complex z1=act(L,z0);
	return hypDist(z0,z1);
    }




}