import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;


/**This is used to record the positions of points when you click.
   Usually this class has more stuff in it, like complex arithmetic.*/

public class HyperbolicTile {
    String[] S=new String[4];
    Complex[] h=new Complex[4];
    Complex[] d=new Complex[4];
    int parity;

    public HyperbolicTile(int k) {
	int[] A={0,2*k+1,2*k+2,2*k+3};
	for(int i=0;i<4;++i) {
	    if(A[i]>16) A[i]=A[i]-16;
	}
	for(int i=0;i<4;++i) {
	    S[i]=word(A[i]);
	    h[i]=vertexHalfPlane(S[i]);
	    d[i]=vertexDisk(S[i]);
	}
	parity=(k+1)%2;
    }

    public HyperbolicTile(HyperbolicTile A) {
	for(int i=0;i<4;++i) {
            S[i]=new String(A.S[i]);
	    h[i]=new Complex(A.h[i]);
	    d[i]=new Complex(A.d[i]);
	}
	parity=A.parity;
    }


    public HyperbolicTile moveBy(String SS) {
	HyperbolicTile T=new HyperbolicTile(this);
	for(int i=0;i<4;++i) {
            T.S[i]=simplify(T.S[i]+SS);
	    T.h[i]=vertexHalfPlane(T.S[i]);
	    T.d[i]=vertexDisk(T.S[i]);
	}
	T.parity=parity;
	return T;

    }

    public Complex vertexDisk(int a) {
	String S=word(a);
	return vertexDisk(S);
    }


    public static Complex vertexDisk(String S) {
	 Complex z=HyperbolicGeometry.initial();
         Lattice L=GroupAction.getMatrixLeft(S);
	 Complex w=HyperbolicGeometry.act(L,z);
	 Complex w2=HyperbolicGeometry.transform(w);
	 return w2;
    }

    public static Complex vertexHalfPlane(String S) {
	 Complex z=HyperbolicGeometry.initial();
         Lattice L=GroupAction.getMatrixLeft(S);
	 Complex w=HyperbolicGeometry.act(L,z);
	 return w;
    }



    public void render(Manager M,Graphics2D g) {
	for(int i=0;i<4;++i) {
	    int j=(i+1)%4;
	    Path2D.Double gp=new Path2D.Double();
	    gp=HyperbolicGeometry.join(h[i],h[j]);
	    gp=M.H.transform(gp);
	    Color C=M.C.QUAD.M[0].C;
	    if(i%2==parity) C=M.C.QUAD.M[1].C;
	    g.setColor(C);
	    g.draw(gp);
	    g.setColor(M.C.QUAD.M[2].C);
	    gp=HyperbolicGeometry.join(h[parity+0],h[parity+2]);
	    gp=M.H.transform(gp);
	    if(M.C.QUAD.L[2].on==1) g.draw(gp);
	    g.setColor(M.C.QUAD.M[3].C);
	    int p1=(parity+1)%4;
	    int p3=(parity+3)%4;
	    gp=HyperbolicGeometry.join(h[p1],h[p3]);
	    gp=M.H.transform(gp);
	    if(M.C.QUAD.L[3].on==1) g.draw(gp);
	}
    }




    

    public static double pointRadius(Complex z) {
	double d=z.norm();
	double e=.05*(1-d);
	return e;
    }

    public static String word(int k) {
	if(k==0) return "";
	if(k==1) return "A";
	if(k==2) return "ba";
	if(k==3) return "baa";
	if(k==4) return "baaa";
	if(k==5) return "a";
	if(k==6) return "ABc";
	if(k==7) return "AABc";		
        if(k==8) return "AABcAc";
        if(k==9) return "Ac";
	if(k==10) return "bac";
 	if(k==11) return "baac";
	if(k==12) return "baaac";
	if(k==13) return "ac";
	if(k==14) return "AB";
	if(k==15) return "AAB";
	if(k==16) return "AABcA";
	return null;
    }


    /**This removes redundancies in the word. It kills aA for instance.*/


    public static String simplify(String s) {
	boolean test=false;
	String t=new String(s);
	int count=0;
	while(test==false) {
	    int n=t.length();
	    t=removeDouble(t);
	    if(n==t.length()) test=true;
	    ++count;
	    if(count==100) test=true; //avoid hangups
	}
	return t;
    }



    public static String removeDouble(String s) {
	for(int i=0;i<s.length()-1;++i) {
	    String t=s.substring(i,i+2);
	    if(t.equals("aA")==true) return removePiece(s,i);
	    if(t.equals("Aa")==true) return removePiece(s,i);
	    if(t.equals("bB")==true) return removePiece(s,i);
	    if(t.equals("Bb")==true) return removePiece(s,i);
	    if(t.equals("cc")==true) return removePiece(s,i);
	}
	return s;
    }


    public static String removePiece(String s,int loc) {
	String s1=s.substring(0,loc);
	String s2=s.substring(loc,loc+2);
	String s3=s.substring(loc+2,s.length());
	return s1+s3;
    }




    /**grow the tiling*/

    public static String[] totalWordList(HyperbolicTile[] T) {
	String[] S=new String[4*T.length];
	int count=0;
	for(int i=0;i<T.length;++i) {
	    for(int j=0;j<4;++j) {
		S[count]=new String(T[i].S[j]);
		++count;
	    }
	}
	S=ListHelp.irredundant(S,count);
	return S;
    }



    public static HyperbolicTile[] flower() {
	HyperbolicTile[] Z=new HyperbolicTile[8];
         for(int i=0;i<8;++i) {
           Z[i]=new HyperbolicTile(i);
	 }
	 return Z;
    }

    public static HyperbolicTile[] grow(HyperbolicTile[] Y) {
	int count=0;
	String[] S=totalWordList(Y);
	HyperbolicTile[] Z=new HyperbolicTile[S.length*16];
        for(int i=0;i<8;++i) {
         Z[count]=new HyperbolicTile(i);
         int freeze=count;
         ++count;
         for(int j=0;j<S.length;++j) {
             Z[count]=Z[freeze].moveBy(S[j]);
             ++count;
	 }
      }
      Z=ListHelp.irredundant(Z,count);
      return Z;
    }

    public static HyperbolicTile[] addSpecial(HyperbolicTile[] Y) {
	HyperbolicTile[] Z=new HyperbolicTile[12];
	for(int i=0;i<8;++i) Z[i]=new HyperbolicTile(Y[i]);
	Z[8]=Y[6].moveBy("b");
	Z[9]=Y[6].moveBy("bc");
	Z[10]=Y[0].moveBy("B");
	Z[11]=Y[0].moveBy("Bc");
	return Z;
    }



}