import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class Lattice {
    BigVector[] v=new BigVector[2];
    boolean special;

    public Lattice() {
	v[0]=new BigVector();
	v[1]=new BigVector();
    }

    public Lattice(Lattice L) {
	v[0]=new BigVector(L.v[0]);
	v[1]=new BigVector(L.v[1]);
    }

    public Lattice(int a,int b,int c,int d) {
	v[0]=new BigVector(a,b);
	v[1]=new BigVector(c,d);
	special=false;
	if((a==1)&&(b==0)&&(c==0)&&(d==9)) special=true;
    }

    public BigInteger det() {
	BigInteger a=v[0].x[0].multiply(v[1].x[1]);
	BigInteger b=v[0].x[1].multiply(v[1].x[0]);
	BigInteger c=a.subtract(b);
	return c;
    }


    /**Inverse up to scaling*/
    public Lattice inverse() {
	Lattice L=new Lattice();
	L.v[0]=new BigVector(v[1].x[1],v[0].x[1]);
	L.v[1]=new BigVector(v[1].x[0],v[0].x[0]);
	L.v[0].x[1]=L.v[0].x[1].negate();
	L.v[1].x[0]=L.v[1].x[0].negate();
	return L;
    }

    public Lattice transpose() {
	Lattice L=new Lattice();
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		L.v[i].x[j]=new BigInteger(this.v[j].x[i].toString());
	    }
	}
	return L;
    }

    /**This is multiplication*/

    public Lattice act(Lattice L) {
	Lattice M=new Lattice();
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		M.v[i].x[j]=new BigInteger("0");
		for(int k=0;k<2;++k) {
		    M.v[i].x[j]=M.v[i].x[j].add(v[k].x[i].multiply(L.v[j].x[k]));
		}
	    }
	}
	M=M.clearFactors();
	M=M.transpose();
	return M;
    }


    /**all the lattices on the list A should be equivalent*/

    public static boolean equivalent(Lattice A,Lattice B) {
	Lattice L1=A.inverse();
	Lattice L2=L1.act(B);
	BigInteger d=L2.det();
	if(d.compareTo(new BigInteger("1"))==0) return true;
	if(d.compareTo(new BigInteger("-1"))==0) return true;
	return false;
    }


    public Lattice scale(BigInteger d) {
	Lattice L=new Lattice();
	for(int i=0;i<2;++i) {
	    L.v[i]=v[i].scale(d);
	}
	return L;
    }

    public Lattice clearFactors() {
	Lattice L=new Lattice(this);
	BigInteger I0=L.v[0].x[0].gcd(L.v[0].x[1]);
	BigInteger I1=L.v[1].x[0].gcd(L.v[1].x[1]);
	BigInteger I2=I0.gcd(I1);
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		L.v[i].x[j]=L.v[i].x[j].divide(I2);
	    }
	}
	return L;
    }


    /**These routines help with recognizing lattices.
       We are changing the representative of the lattice
       within the Serre-equivalence class*/

    public Lattice tweak0(int p) {
	Lattice L=new Lattice(this);
	L.v[0]=L.v[0].divideByUnits(p);
	L.v[1]=L.v[1].divideByUnits(p);
	return L;
    }

    public Lattice tweak1(int p) {
	Lattice L=new Lattice(this);
	BigVector a=BigVector.add(v[0],v[1]);
	a=a.divideByUnits(p);
	L.v[1]=new BigVector(a);
	return L;
    }

    public Lattice tweak2(int p) {
	Lattice L=new Lattice(this);
	BigVector a=BigVector.subtract(v[0],v[1]);
	a=a.divideByUnits(p);
	L.v[1]=new BigVector(a);
	return L;
    }

    public Lattice tweak3(int p) {
	Lattice L=new Lattice(this);
	BigVector a=BigVector.subtract(v[0],v[1]);
	a=a.divideByUnits(p);
	L.v[0]=new BigVector(a);
	return L;
    }


    /**Printing methods*/

    public void print() {
	v[0].print();
	v[1].print();
    }



    public void render(Graphics2D g,int x,int y,Color C) {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
	      String X0=v[j].x[i].toString();
	      g.setColor(C);
	      int L=X0.length();
	      int t=(int)(70/X0.length()+1);
	      if(t>20) t=20;
              g.setFont(new Font("Helvetica",Font.PLAIN,t));
	      g.drawString(X0,x+50*i,y+50*j);
	    }
	}
    }



}


