import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;

/**This is the window where things are drawn*/

public class MetricCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Point CURSOR;
    Boolean DRAG;
    Manager M;

     public MetricCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
     }

    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      drawBg(g);
      drawLattice(g,0);
   }

    public void drawBg(Graphics2D g) {
	g.setColor(new Color(140,160,180));
	g.fillRect(0,0,getWidth(),120);
	g.setColor(new Color(140,160,180));
	g.fillRect(0,120,getWidth(),240);
	g.setColor(new Color(210,230,250));
	g.fillRect(0,240,getWidth(),170);

	Color[] C1={new Color(80,160,255),new Color(130,200,255)};
	for(int i=0;i<8;++i) {
	    Path2D.Double gp=new Path2D.Double();
	    gp.moveTo(100*i,0);
	    gp.lineTo(100*i+100,0);
	    gp.lineTo(100*i+100,80);
	    gp.lineTo(100*i,80);
	    gp.closePath();
	    g.setColor(C1[i%2]);
	    g.fill(gp);
	}

	Color[] C2={new Color(255,150,255),new Color(255,200,255)};
	for(int i=0;i<8;++i) {
	    Path2D.Double gp=new Path2D.Double();
	    gp.moveTo(100*i,120);
	    gp.lineTo(100*i+100,120);
	    gp.lineTo(100*i+100,200);
	    gp.lineTo(100*i,200);
	    gp.closePath();
	    g.setColor(C1[i%2]);
	    g.fill(gp);
	}


    }



    public void drawLattice(Graphics2D g,int t) {
	try{String S=M.H.WORD[0];}
	catch(Exception e) {return;}

	Lattice L0=new Lattice(1,0,0,1);
	
	int chain = M.C.CHAIN.val;
	for(int i=0;i<chain+1;++i) {
	  Lattice L2=GroupAction.leftAction(2,M.H.WORD[i],L0);
	  L2.render(g,5+100*i,25,Color.black);
	  Lattice L3=GroupAction.leftAction(3,M.H.WORD[i],L0);
	  L3.render(g,5+100*i,145,Color.black);
	}


	int tot2=0;
	int tot3=0;
	for(int i=0;i<chain;++i) {
	  Lattice L21=GroupAction.leftAction(2,M.H.WORD[i],L0);
	  Lattice L31=GroupAction.leftAction(3,M.H.WORD[i],L0);
	  Lattice L22=GroupAction.leftAction(2,M.H.WORD[i+1],L0);
	  Lattice L32=GroupAction.leftAction(3,M.H.WORD[i+1],L0);
	  int n1=Serre.distance(2,L21,L22);
	  int n2=Serre.distance(3,L31,L32);
	  tot2=tot2+n1;
	  tot3=tot3+n2;
	  Integer N1=new Integer(n1);
	  Integer N2=new Integer(n2);
	  g.setColor(Color.blue);
          g.setFont(new Font("Helvetica",Font.PLAIN,30));
	  g.drawString(N1.toString(),92+100*i,110);
	  g.drawString(N2.toString(),92+100*i,230);
	}

	  Integer N1=new Integer(tot2);
	  Integer N2=new Integer(tot3);
	  g.setColor(Color.blue);
          g.setFont(new Font("Helvetica",Font.PLAIN,30));
	  g.drawString(N1.toString(),200,278);;
	  g.drawString(N2.toString(),200,308);

          Lattice L21=GroupAction.leftAction(2,M.H.WORD[0],L0);
	  Lattice L31=GroupAction.leftAction(3,M.H.WORD[0],L0);
	  Lattice L22=GroupAction.leftAction(2,M.H.WORD[chain],L0);
	  Lattice L32=GroupAction.leftAction(3,M.H.WORD[chain],L0);
	  int n1=Serre.distance(2,L21,L22);
	  int n2=Serre.distance(3,L31,L32); 
	  g.setColor(Color.red); 
          N1=new Integer(n1);
	  N2=new Integer(n2);
          g.drawString(N1.toString(),600,278);
	  g.drawString(N2.toString(),600,308);

	  g.setColor(Color.black);
          g.setFont(new Font("Helvetica",Font.PLAIN,20));
	  g.drawString("total 2-tree length",10,275);
	  g.drawString("total 3-tree length",10,305);
	  g.drawString("2-tree geodesic dist",400,275);
	  g.drawString("3-tree geodesic dist",400,305);



    }




    /**Mouse events*/
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	CURSOR=J.X;
	SOURCE=unTransform(J.X);
    }

     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
     }


    public void mousePressed(MouseEvent e) {
    }



    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}  

    /**accepts mouse clicks and rescales*/
 
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X); 
	}
	M.repaint();
     }


    public void doMouseClick(int test) {
	if(test==1) scaleUp(CURSOR,-1);
	if(test==3) scaleUp(CURSOR,1);
	if(test==2) {
	    SOURCE=unTransform(CURSOR);
	}
	if(test>=4) {
            SOURCE=unTransform(CURSOR); 
	}

	M.repaint();
     }



}



