import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.image.*;

/**This is the window where things are drawn*/

public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener,KeyListener {
    int TYPE;    //0 for prime=2 and 1 for prime=3
    Point CURSOR;
    Boolean DRAG;
    Manager M;
    Tree TREE;
    int IMAGE;
    int INDEX,SHADOW;

     public PictureCanvas(int type) {
	 TYPE=type;
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(400,400,390);
	 DRAG=false;
	 TREE=Tree.make(2+type,6-type);
     }

    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      int m=M.C.TREE.mode;
      Color C=Color.white;
      if((m==1)&&(TYPE==0)) C=new Color(140,160,180);
      if((m==1)&&(TYPE==1)) C=new Color(180,200,220);
      if((m==0)&&(TYPE==0)) C=new Color(255,180,0);
      if((m==0)&&(TYPE==1)) C=new Color(255,220,0);
      drawBg(g,C);
      fillPoint(g,new Complex(0,0),1,Color.white,500);
      drawTree(g);
      if(m==0) drawAction(g);
      if(m==1) drawPath(g);
      drawShadow(g);
   }

    public void drawBg(Graphics2D g,Color C) {
	g.setColor(C);
	g.fillRect(0,0,getWidth(),getHeight());
    }


    public void drawTree(Graphics2D g) {
	int l=TREE.firstLeaf();
	Path2D.Double p=new Path2D.Double();
	int prime=TREE.degree-1;
	for(int i=0;i<l;++i) {
	    int n=TREE.V[i].degree;
	    for(int j=0;j<n;++j) {
		int k=TREE.V[i].neighbor[j];
		p.moveTo(TREE.V[i].z.x,TREE.V[i].z.y);
		p.lineTo(TREE.V[k].z.x,TREE.V[k].z.y);
	    }
	}
	p=transform(p);
	g.setColor(new Color(200,200,200));
	g.draw(p);
    }

    public void drawEdge(Graphics2D g,int a,int b,Color C) {
	Path2D.Double p=new Path2D.Double();
	Complex z1=TREE.V[a].z;
	Complex z2=TREE.V[b].z;
	p.moveTo(z1.x,z1.y);
	p.lineTo(z2.x,z2.y);
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(3));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public Lattice currentLattice() {
	return TREE.V[INDEX].L;
    }



    public void getIndex() {
	INDEX=TREE.getNearest(SOURCE);
	if(INDEX==-1) return;
	System.out.println("vertex "+INDEX);
	int i=INDEX;
	if(TREE.V[i].L==null) return;
	Lattice L=TREE.V[INDEX].L;
	int choice=M.C.CHOICE;
    }


    public void drawAction(Graphics2D g) {
	if(INDEX==-1) return;
	Lattice L=TREE.V[INDEX].L;
	int p=TREE.degree-1;
	Lattice[] B=Serre.fullReduce(p,L);
	Lattice[] C=GroupAction.leftAction(p,M.C.WORD[0].S,B);
	B[B.length-1].render(g,5,25,Color.black);
	C[C.length-1].render(g,getWidth()-80,25,new Color(150,0,150));
	drawLatticeChain(g,C,new Color(255,150,250),5);
	drawLatticeChain(g,B,Color.black,2);
    }


    public void drawPath(Graphics2D g) {
	try {
	    String S=M.H.WORD[0];
	}
	catch(Exception e) {return;}

	Lattice[] A={new Lattice(1,0,0,1)};
	int p=TREE.degree-1;
	String[] S=new String[4];
	for(int i=0;i<M.C.CHAIN.val;++i) {
	  String S0=M.H.WORD[i];
   	  String S1=M.H.WORD[i+1];
	  Lattice[] B1=GroupAction.leftAction(p,S0,A);
	  Lattice[] B2=GroupAction.leftAction(p,S1,A);
	  drawGeodesic(g,B1,B2,Color.black,2);
	}
    }





    public void drawShadow(Graphics2D g) {
	if(SHADOW==-1) return;
	Lattice D=new Lattice(1,0,0,1);
	try{
	   D=TREE.V[SHADOW].L;
	}
	catch(Exception e) {return;}
	int p=TREE.degree-1;
	D.render(g,5,getWidth()-70,Color.blue);
	Complex z=TREE.V[SHADOW].z;
	double d=TREE.V[SHADOW].depth;
	double r=.05*Math.pow(1.0/(p+1),.5*d);
	fillPoint(g,z,r,Color.blue,16);
    }


    public void drawLatticeChain(Graphics2D g,Lattice[] B,Color C,int thick) {	
        Path2D.Double gp=new Path2D.Double();
	int p=TREE.degree-1;
	int[] t=Serre.position(p,B);
	Complex[] z=VertexGeometry.geometry(p,t);
	for(int j=0;j<z.length;++j) {
	    double x=z[j].x;
	    double y=z[j].y;
	    if(j==0) gp.moveTo(x,y);
	    if(j!=0) gp.lineTo(x,y);
	}
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	gp=transform(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }


    public void drawGeodesic(Graphics2D g,Lattice[] B1,Lattice[] B2,Color C,int thick) {	
        Path2D.Double gp=new Path2D.Double();
	int p=TREE.degree-1;
	int overlap=Serre.overlap(p,B1,B2);
	int[] t1=Serre.position(p,B1);
	int[] t2=Serre.position(p,B2);
	Complex[] z=VertexGeometry.geodesic(p,overlap,t1,t2);
	for(int j=0;j<z.length;++j) {
	    double x=z[j].x;
	    double y=z[j].y;
	    if(j==0) gp.moveTo(x,y);
	    if(j!=0) gp.lineTo(x,y);
	}
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	gp=transform(gp);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));


    }












    /**Mouse events*/
    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	Complex z=unTransform(J.X);
	SHADOW=TREE.getNearest(z);
	CURSOR=J.X;
	repaint();
    }

     public void mouseDragged(MouseEvent e) {
     }


    public void mousePressed(MouseEvent e) {
    }



    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}  

    /**accepts mouse clicks and rescales*/
 
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==1) scaleUp(J.X,-1);
	if(J.mode==3) scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X); 
            getIndex();
	}
	M.repaint();
     }



    public void doMouseClick(int test) {
	if(test==1) scaleUp(CURSOR,-1);
	if(test==3) scaleUp(CURSOR,1);
	if(test==2) {
	    SOURCE=unTransform(CURSOR);
	    getIndex();
	}
	M.repaint();
     }


    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') DRAG=true;
    }

    public void keyReleased(KeyEvent e) {
	DRAG=false;
    }

    public void keyTyped(KeyEvent e) {


	char ch=e.getKeyChar();
	int test=-1;
	if(ch=='z') test=1;   
	if(ch=='x') test=2;   
	if(ch=='c') test=3;  
	doMouseClick(test); 

	repaint();
    }





}



