import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class SelectWord {
    double x,y,w,h;
    String S;
    int on;
    Font FONT;

    public SelectWord(String S) {
	this.S=S;
    }

    public SelectWord(double x,double y,double w,double h,String S) {
	this.x=x;
	this.y=y;
	this.w=w;
	this.h=h;
        this.FONT=new Font("Helvetica",Font.PLAIN,18);
	this.S=S;
    }

    public int inside(Point p) {
        int test=0;
	if((p.x>x)&&(p.x<x+w)&&(p.y>y)&&(p.y<y+h)) test=1;
	return(test);
    }

    /** drawing methods */

    public void render(Graphics g,Color C1,Color C2,Color C3) {
	g.setColor(C1);
	g.fillRect((int)(x),(int)(y),(int)(w),(int)(h));
        g.setColor(C2);
	if(on==0) g.setColor(Color.blue);
	g.drawRect((int)(x),(int)(y),(int)(w),(int)(h));
	g.setColor(C3);
        g.setFont(FONT);
	g.drawString(S,(int)(x+3),(int)(y+h-2));
    }

    public int getLetter(int i) {
       String T=S.substring(i,i+1);
       Integer I=new Integer(T);
       return I.intValue();
    }

    public int[] getWord() {
	int n=S.length();
	int[] w=new int[n];
	for(int i=0;i<n;++i) w[i]=getLetter(i);
	return w;
    }

    public void activate(Point X) {
	if(inside(X)==1) on=1;
	if(inside(X)==0) on=0;
    }

    public boolean modify(KeyEvent e) {
	if(on==0) return(false);
	int n=S.length();

        if (e.getKeyChar()==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

	if(n>30) return false;
        int ch=(int)(e.getKeyChar()-'0');
        if ((ch>=0)&&(ch<=7)) S=S+ch;

	if(ch==49) S=S+"a";
	if(ch==17) S=S+"A";
	if(ch==50) S=S+"b";
	if(ch==18) S=S+"B";
	if(ch==51) S=S+"c";
	if(ch==19) S=S+"C";
	return(true);
    }

}
