import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class Serre {

    /**These routines build the Serre tree out to some depth*/

    /**Star of the initial vertex*/

    public static void initialize(int p,Tree T) {
	T.degree=p+1;
	T.count=p+2;
	T.V[0]=new Vertex(0,p+1);
	T.V[0].L=new Lattice(1,0,0,1);
	T.V[0].z=new Complex(0,0);
	T.V[0].depth=0;

	for(int i=1;i<T.degree+1;++i) {
	    T.V[0].neighbor[i-1]=i;
	    T.V[i]=new Vertex(i,1);
	    T.V[i].neighbor[0]=0;
   	    T.V[i].z=new Complex(i-1-1.0*p/2,1);
	    T.V[i].depth=1;
	}

	Lattice[] L=expand(p,T.V[0].L);
	for(int i=0;i<T.degree;++i) T.V[i+1].L=L[i];
    }


    /**Add a layer*/

    public static void grow(Tree T,int D) {
	int p=T.degree-1;
	int n=T.count;
	int count=0;
	for(int i=0;i<n;++i) {
	    if(T.V[i].degree==1) {
	      T.V[i].degree=T.degree;
	      Lattice[] L=expand(p,T.V[i].L);
	      for(int j=0;j<L.length;++j) {
		  Complex z=T.V[i].z;
		  T.V[n+count]=new Vertex(n+count,T.degree);
		  T.V[n+count].L=new Lattice(L[j]);
		  double DD=Math.pow(p,D);
		  T.V[n+count].z=new Complex(z.x+1.0*j/DD-.5*(p-1)/DD,z.y+1/DD);
		  T.V[n+count].neighbor[0]=i;
		  T.V[n+count].degree=1;
		  T.V[n+count].depth=D+1;
		  T.V[i].neighbor[j+1]=n+count;
		  ++count;
	      }
	    }
	}
	T.count=n+count;
    }


    /**This gets the full chain back to the identity*/

    public static Lattice[] fullReduce(int p,Lattice A) {
	boolean test=false;
	Lattice L1=new Lattice(A);
	Lattice[] B=new Lattice[500];
	int count=0;

	while(test==false) {
	    B[count]=new Lattice(L1);
	    Lattice L2=reduce(p,L1);
	    if(Lattice.equivalent(L1,L2)==true) test=true;
	    L1=new Lattice(L2);
	    ++count;
	}
	Lattice[] B2=new Lattice[count];
	for(int i=0;i<count;++i) B2[i]=new Lattice(B[count-1-i]);
	return B2;
    }

    public static Lattice reduce(int p,Lattice A) {
	Lattice B=new Lattice(A);
	boolean test=true;
	if(A.v[0].x[1].compareTo(new BigInteger("0"))!=0) test=false;
	if(A.v[1].x[0].compareTo(new BigInteger("0"))!=0) test=false;
	if(A.v[0].x[0].compareTo(new BigInteger("1"))!=0) test=false;
	if((test==true)&&(A.v[1].x[1].compareTo(new BigInteger("1"))==0)) return A;
	if(test==true) return reduceSpecial(p,A);
	return reduceGeneral(p,A);
    }

    public static Lattice reduceGeneral(int p,Lattice A) {
	Lattice B=new Lattice(A);
	B.v[0].x[0]=A.v[0].x[0].divide(copy(p));
	B.v[1].x[0]=B.v[1].x[0].mod(B.v[0].x[0]);
	return B;
    }

    public static Lattice reduceSpecial(int p,Lattice A) {
	Lattice B=new Lattice(A);
	B.v[1].x[1]=A.v[1].x[1].divide(copy(p));
	return B;
    }

    public static BigInteger copy(int p0) {
	Integer p1=new Integer(p0);
	BigInteger p2=new BigInteger(p1.toString());
	return p2;
    }


    /**These routines get the forward neighbors of a vertex*/


    /**classifies the lattice:
       0: identity lattice
       1: special lattice
       2: general lattice
    */


    public static int classify(int p,Lattice A) {
	boolean test=true;
	if(A.v[0].x[1].compareTo(new BigInteger("0"))!=0) test=false;
	if(A.v[1].x[0].compareTo(new BigInteger("0"))!=0) test=false;
	if(A.v[0].x[0].compareTo(new BigInteger("1"))!=0) test=false;
	if((test==true)&&(A.v[1].x[1].compareTo(new BigInteger("1"))==0)) return 0;
	if(test==false) return 2;
	return 1;
    }


    public static Lattice[] expand(int p,Lattice A) {
	int t=classify(p,A);
	if(t==0) return expandIdentity(p,A);
	if(t==1) return expandSpecial(p,A);
	return expandGeneral(p,A);
    }

    public static Lattice[] expandIdentity(int p,Lattice A) {
	Lattice[] B=new Lattice[p+1];
	for(int i=0;i<p;++i) B[i]=expand(p,i,A);
	B[p]=new Lattice(A);
	B[p].v[1].x[1]=A.v[1].x[1].multiply(copy(p));
	return B;
    }

    public static Lattice[] expandSpecial(int p,Lattice A) {
	Lattice[] B=new Lattice[p];
	for(int i=1;i<p;++i) B[i]=expand(p,i,A);
	B[0]=new Lattice(A);
	B[0].v[1].x[1]=A.v[1].x[1].multiply(copy(p));
	Lattice[] B2=new Lattice[B.length];
	for(int i=0;i<B.length;++i) B2[i]=B[B.length-1-i];
	return B2;
    }

    public static Lattice[] expandGeneral(int p,Lattice A) {
	Lattice[] B=new Lattice[p];
	for(int i=0;i<p;++i) B[i]=expand(p,i,A);
	if(A.v[1].x[1].compareTo(new BigInteger("1"))==0)  return B;
	Lattice[] B2=new Lattice[B.length];
	for(int i=0;i<B.length;++i) B2[i]=B[B.length-1-i];
	return B2;
    }

    public static Lattice expand(int p,int k,Lattice A) {
	Lattice B=new Lattice(A);
	B.v[0].x[0]=A.v[0].x[0].multiply(copy(p));
	B.v[1].x[0]=A.v[1].x[0].add(A.v[0].x[0].multiply(copy(k)));
	return B;
    }


    /**This routine gets the position of the expansion within list*/


    public static int[] position(int p,Lattice[] B) {
	int[] t=new int[B.length];
	t[0]=0;
	if(B.length==1) return t;

	int s=classify(p,B[1]);

	for(int i=0;i<B.length-1;++i) {
	    t[i+1]=position(p,B[i],B[i+1]);
	}

	if(s==2) return t;
	for(int i=2;i<B.length;++i) t[i]=p-1-t[i];
	return t;
    }



    public static int position(int p,Lattice A,Lattice B) {
	int t=classify(p,A);

	if(t==0) {
	    int t2=classify(p,B);
	    if(t2==1) return p;
            return B.v[1].x[0].intValue();
	}

	BigInteger x=B.v[1].x[0].subtract(A.v[1].x[0]);
	x=x.divide(A.v[0].x[0]);
	return x.intValue();

    }


    /**This computes the Serre distance between two lattices*/
    public static int distance(int p,Lattice A0,Lattice B0) {
	Lattice[] A=fullReduce(p,A0);
	Lattice[] B=fullReduce(p,B0);
	int count=overlap(p,A,B);
	return A.length+B.length-2*count;
    }


    /**This computes the Serre distance between two lattice chains*/
    public static int overlap(int p,Lattice[] A,Lattice[] B) {
	int match=0;
	int n=A.length;
	int count=0;
	if(n>B.length) n=B.length;
	for(int i=0;i<n;++i) {
	   boolean test=Lattice.equivalent(A[i],B[i]);
	   if(test==true) ++count;
	}
	return count;
    }











}
