import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This is used to record the positions of points when you click.
   Usually this class has more stuff in it, like complex arithmetic.*/

public class Tree {
    int count;
    int degree;
    Vertex[] V=new Vertex[1000000];

    public Tree() {}

    public Tree(Tree T) {
	this.count=T.count;
	for(int i=0;i<T.count;++i) this.V[i]=new Vertex(T.V[i]);
    }

    public static Tree make(int p,int depth) {
	Tree T=new Tree();
	Serre.initialize(p,T);
	for(int i=0;i<depth;++i) Serre.grow(T,i+1);
	scale(T,2.0/(p+1),(p+1)/6.0);
	circular(T);
	return T;
    }

    public static void scale(Tree T,double a1,double a2) {
	for(int i=0;i<T.count;++i) {
             T.V[i].z.x=T.V[i].z.x*a1; 
             T.V[i].z.y=T.V[i].z.y*a2; 
	}
    }

    public static void circular(Tree T) {
	int p=T.degree-1;
	Complex u=new Complex(0,-1);
	for(int i=0;i<T.count;++i) {
	    double t=T.V[i].z.x;
	    double r=T.V[i].z.y;
	    r=Math.pow(r,T.degree-1);
	    double c=Math.cos(Math.PI*t);
	    double s=Math.sin(Math.PI*t);
	    T.V[i].z=Complex.times(u,new Complex(r*c,r*s));
	}
    }

    /**This routine recognizes a lattice*/


    public int firstLeaf() {
	for(int i=0;i<count;++i) {
	    if(V[i].degree==1) return i;
	}
	return -1;
    }

    public int getNearest(Complex w) {
	int index=-1;
	double min=1;
	double test=0;
	for(int i=0;i<count;++i) {
	    test=Complex.dist(V[i].z,w);
	    if(min>test) {
		min=test;
		index=i;
	    }
	}
	return index;
    }

    public void print() {
	for(int i=0;i<count;++i) V[i].print();
    }


}


