import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This is used to record the positions of points when you click.
   Usually this class has more stuff in it, like complex arithmetic.*/

public class Vertex {
    int index;
    int degree;
    int depth;
    int[] neighbor=new int[101];
    Lattice L;
    Complex z;

    public Vertex(int k,int d) {
	this.index=k;
	this.degree=d;
	this.z=new Complex(0,0);
    }

    public Vertex(Vertex V) {
	this.index=V.index;
	this.degree=V.degree;
	this.depth=V.depth;
	for(int i=0;i<V.degree;++i) this.neighbor[i]=V.neighbor[i];
	this.z=new Complex(V.z);
	if(V.L!=null) this.L=new Lattice(V.L);
    }

    public Vertex add(int vtx) {
	Vertex V=new Vertex(this);
	for(int i=0;i<V.degree;++i) {
	    if(vtx==neighbor[i]) return V;
	}
	int d=V.degree;
	V.neighbor[d]=vtx;
	++V.degree;
	return V;
    }

    public Vertex trim(int n) {
	Vertex V=new Vertex(this);
	int count=0;
	for(int i=0;i<this.degree;++i) {
	    if(neighbor[i]<n) {
		V.neighbor[count]=neighbor[i];
		++count;
	    }
	}
	V.degree=count;
	return V;
    }

    public void print() {
	System.out.print(index+": ");
	for(int i=0;i<degree;++i) System.out.print(neighbor[i]+" ");
	System.out.println("");
    }
}


