import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class VertexGeometry {

    public static Complex[] geodesic(int p,int overlap,int[] t1,int[] t2) {
	Complex[] z1=geometry(p,t1);
	Complex[] z2=geometry(p,t2);
	int dist=z1.length+z2.length-2*overlap;
	int part1=z1.length-overlap;
	int part2=z2.length-overlap;

	Complex[] z=new Complex[part1+part2+1];
	int count=0;
	for(int i=z1.length-1;i>z1.length-part1-1;--i) {
	    z[count]=new Complex(z1[i]);
	    ++count;
	}

	for(int i=overlap-1;i<z2.length;++i) {
	    z[count]=new Complex(z2[i]);
	    ++count;
	}
	return z;
    }







    public static Complex[] geometry(int p,int[] t) {
	Complex u=new Complex(0,-1);
	Complex[] z=new Complex[t.length];
	z[0]=new Complex(0,0);
	if(t.length==1) return z;
	z[1]=new Complex(t[1]-1.0*p/2,1);
	for(int i=2;i<t.length;++i) {
	   double D=Math.pow(p,i-1);
	   int j=t[i];
	   z[i]=new Complex(z[i-1].x+1.0*j/D-.5*(p-1)/D,z[i-1].y+1/D);
	}
	for(int i=0;i<z.length;++i) {
	    z[i].x=z[i].x*(2.0/(p+1));
	    z[i].y=z[i].y*(p+1)/6.0;
	}

	for(int i=0;i<z.length;++i) {
	    double theta=z[i].x;
	    double r=z[i].y;
	    r=Math.pow(r,p);
	    double c=Math.cos(Math.PI*theta);
	    double s=Math.sin(Math.PI*theta);
	    z[i]=new Complex(r*c,r*s);
	    z[i]=Complex.times(u,z[i]);
	}

	return z;
    }




}


