import java.awt.*;


public class WheelTest {

    public static Lattice[] lattice(int i) {
	String S=word(i);
	Lattice L=new Lattice(1,0,0,1);
	Lattice[] L1={L};
	Lattice[] L2=GroupAction.leftAction(2,S,L1);
	Lattice[] L3=GroupAction.leftAction(3,S,L1);
	Lattice[] A={L2[L2.length-1],L3[L3.length-1]};
	return A;
    }

    public static String word(int k) {
	if(k==0) return "";
	if(k==1) return "A";
	if(k==2) return "ba";
	if(k==3) return "baa";
	if(k==4) return "baaa";
	if(k==5) return "a";
	if(k==6) return "ABc";
	if(k==7) return "AABc";		
        if(k==8) return "AABcAc";
        if(k==9) return "Ac";
	if(k==10) return "bac";
 	if(k==11) return "baac";
	if(k==12) return "baaac";
	if(k==13) return "ac";
	if(k==14) return "AB";
	if(k==15) return "AAB";
	if(k==16) return "AABcA";
	return null;
    }

    /**This gets the convex hull of the 3 lattices in
       the triangle*/

    public static Lattice[] hull(int p,int i0) {
	int i1=(i0+1)%16;
	Lattice[] A0=lattice(i0);
	Lattice[] B0=lattice(i1);

	Lattice A=A0[p-2];
	Lattice B=B0[p-2];
	Lattice[] AA=Serre.fullReduce(p,A);
	Lattice[] BB=Serre.fullReduce(p,B);
	Lattice[] C=new Lattice[AA.length+BB.length];
	int count=0;
	for(int i=0;i<AA.length;++i) {
           C[count]=new Lattice(AA[i]);
	   ++count;
	}
	for(int i=0;i<BB.length;++i) {
	    if(onList(BB[i],C,count)==false) {
               C[count]=new Lattice(BB[i]);
	       ++count;
	    }
	}
	Lattice[] CC=new Lattice[count];
	for(int i=0;i<count;++i) CC[i]=new Lattice(C[i]);
	return CC;
    }

    public static boolean onList(Lattice B,Lattice[] C,int count) {
	for(int i=0;i<count;++i) {
	    if(Lattice.equivalent(B,C[i])==true) return true;
	}
	return false;
    }


    public static Lattice[] hullEdge(int p,int i0) {
	Lattice[] A0=lattice(i0);
	Lattice[] AA=Serre.fullReduce(p,A0[p-2]);
	return AA;
    }



    public static int[] sweetSpot(int q) {
	int count=0;
	int[] A=new int[9];
	for(int i=0;i<9;++i) {
	    A[i]=(i+q+4)%16;
	}
	return A;
    }

    public static int[] fringe(int q) {
	int[] A={(q+4)%16,(q+12)%16};
	return A;
    }

    public static int totalMatch(int p,int i,int j) {
	Lattice[] A=hull(p,i);
	Lattice[] B=hull(p,j);
	return totalMatch(A,B);
    }

    public static int totalMatchEdge(int p,int i,int j) {
	Lattice[] A=hullEdge(p,i);
	Lattice[] B=hullEdge(p,j);
	return totalMatch(A,B);
    }

    public static int totalMatchSpecial(int p,int i,int j) {
	Lattice[] A=hullEdge(p,i);
	Lattice[] B=hull(p,j);
	return totalMatch(A,B);
    }



    public static int totalMatch(Lattice[] A,Lattice[] B) {
	int count=0;
	for(int i=0;i<A.length;++i) {
	    for(int j=0;j<B.length;++j) {
		boolean test=Lattice.equivalent(A[i],B[j]);
		if(test==true) ++count;
	    }
	}
	return count;
    }



    /**This generates a random path in the subgroup generated by a and c*/

    public static String[] randomPath(int k) {
	String S="a";
	String[] A=new String[k+3];

	int r1=9+(int)(8*Math.random());

	A[0]=HyperbolicTile.word(r1);
	A[1]="";
	A[2]="a";

	int memory=0;
	int temp=0;

	for(int i=0;i<k-1;++i) {
	    int b=(int)(3*Math.random());

	    if(memory==0) {
		if(b==0) temp=0;
		if(b==1) temp=2;
		if(b==2) temp=3;
	    }

	    if(memory==1) {
		if(b==0) temp=1;
		if(b==1) temp=2;
		if(b==2) temp=3;
	    }

	    if(memory==2) {
		if(b==0) temp=2;
		if(b==1) temp=0;
		if(b==2) temp=1;
	    }

	    if(memory==3) {
		if(b==0) temp=3;
		if(b==1) temp=0;
		if(b==2) temp=1;
	    }

	    if(temp==0) S="a"+S;
	    if(temp==1) S="A"+S;
	    if(temp==2) S="cac"+S;
	    if(temp==3) S="cAc"+S;

	    memory=temp;
	    A[i+3]=new String(S);
	}

	int r2=0;
	if(memory==0) r2=5;
	if(memory==1) r2=9;
	if(memory==2) r2=13;
	if(memory==3) r2=1;

        r2=r2+(int)(8*Math.random());
	if(r2>16) r2=r2-16;

	A[k+2]=HyperbolicTile.word(r2)+A[k+1];
	return A;
    }




    /**The testing the loss in a path*/
    public static int[] loss(String[] WORD) {

	Lattice L0=new Lattice(1,0,0,1);
	int chain=WORD.length-1;
	int tot2=0;
	int tot3=0;
	for(int i=0;i<chain;++i) {
	  Lattice L21=GroupAction.leftAction(2,WORD[i],L0);
	  Lattice L31=GroupAction.leftAction(3,WORD[i],L0);
	  Lattice L22=GroupAction.leftAction(2,WORD[i+1],L0);
	  Lattice L32=GroupAction.leftAction(3,WORD[i+1],L0);
	  int n1=Serre.distance(2,L21,L22);
	  int n2=Serre.distance(3,L31,L32);
	  tot2=tot2+n1;
	  tot3=tot3+n2;
	}
        Lattice L21=GroupAction.leftAction(2,WORD[0],L0);
	Lattice L31=GroupAction.leftAction(3,WORD[0],L0);
	Lattice L22=GroupAction.leftAction(2,WORD[chain],L0);
	Lattice L32=GroupAction.leftAction(3,WORD[chain],L0);
	int n2=Serre.distance(2,L21,L22);
	int n3=Serre.distance(3,L31,L32);
	int[] N={tot2-n2,tot3-n3};
	return N;
    }



    /**Print out the lattices*/

    public static void latticePrint(int p) {
	for(int q=1;q<=16;++q) {
	  Lattice[] A0=lattice(q);
	  String S=word(q);
  	  Lattice A=A0[p-2];
	  System.out.println("------------");
	  System.out.print("vertex "+q+"   ");
	  System.out.print("word "+S+"   ");
	  System.out.println("prime "+p);
          A.print();
	}
    }


    public static void latticeHullPrint(int p) {
	for(int q=1;q<=16;++q) {
	    Lattice[] A=hull(p,q);
	    String S=word(q);
	    System.out.print("lattice hull "+q+"   ");
 	    System.out.print("word "+S+"   ");
	    System.out.println("prime "+p);
	    for(int i=0;i<A.length;++i) {
		A[i].print();
		System.out.println("----");
	    }
	    System.out.println("------------");
	}
    }




    /**For lemmas 2.4 and 2.5 */

    public static void test0(int p) {
	for(int q=1;q<=16;++q) {
	    int[] w=WheelTest.sweetSpot(q);
	    System.out.print(q+" :");
	    for(int i=0;i<9;++i) {
		int count=WheelTest.totalMatch(p,q,w[i]);
	      System.out.print(count+" ");
	    }
	    System.out.println("");
	}
	System.out.println("done");
    }


    /**An extra test showing that all the red and blue broken
       geodesics map to geodesics*/
    public static void test1(int p) {
	for(int q=1;q<=16;++q) {
	    int[] w=WheelTest.fringe(q);
	    System.out.print(q+" :");
	    for(int i=0;i<2;++i) {
		int count=WheelTest.totalMatchEdge(p,q,w[i]);
	      System.out.print(count+" ");
	    }
	    System.out.println("");
	}
	System.out.println("done");
    }



    /**For lamma 2.6*/

    public static void test2(int p) {
	for(int q=1;q<=8;++q) {
	    System.out.print(q+" :");
	    for(int i=9;i<=16;++i) {
		int count=WheelTest.totalMatch(p,q,i);
	      System.out.print(count+" ");
	    }
	    System.out.println("");
	}
	System.out.println("done");
    }














    public static void printout(Lattice[] L) {
	System.out.println("----------------------");
	for(int i=0;i<L.length;++i) {
	    L[i].print();
	    System.out.println("------");
	}
	System.out.println("----------------------");
    }


}