import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener,MouseMotionListener {
    Manager M;
    SelectColor CS;
    SelectInteger S1,S2,I1,I2,I3,D1,WIDTH,POINT;
    ControlPanelColor COLOR;
    ControlPanel NORM,SELECT;
    ListenSquare[] SPIRAL=new ListenSquare[12];
    ListenSquare PROJ,MAP0,MAP1,MAP2,GO,STOP,EXPONENT,RANDOM;
    Animator ANIM;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,0,300,50);
	 S1=new SelectInteger(200,150,50,25,4,4,12,1);  //poly sides
	 S2=new SelectInteger(200,200,50,25,3,1,8,1); //number of spirals
	 I1=new SelectInteger(5,245,40,20,0,0,9,1);//steps shown
	 I2=new SelectInteger(75,245,40,20,0,0,90,10); //steps shown
	 WIDTH=new SelectInteger(105,90,34,17,3,1,8,1); //spiral width
	 POINT=new SelectInteger(105,130,36,20,0,0,10,1); //point display
	 I3=new SelectInteger(0,340,40,20,1,1,200,1);  //power for animation
	 D1=new SelectInteger(150,470,40,20,25,1,200,1); //delay for animation
	 for(int i=0;i<12;++i) {
	     SPIRAL[i]=new ListenSquare(102+14*i,55,12,12);
	 }
	 PROJ=new ListenSquare(0,390,60,20);
	 MAP0=new ListenSquare(100,390,80,20);
	 MAP1=new ListenSquare(60,390,40,20);
	 MAP2=new ListenSquare(180,390,90,20);
	 EXPONENT=new ListenSquare(80,340,60,20); //preset power for anim
	 GO=new ListenSquare(150,440,30,20);
	 STOP=new ListenSquare(180,440,40,20);
	 ANIM=new Animator(this.M);
	 setPanels();
     }


    public void setPanels() {
	Color[] C0={new Color(50,0,200),Color.white,Color.white,Color.white,Color.orange};
	Color[] C1={new Color(100,0,200),Color.white,Color.white,Color.white,Color.orange};
	Color[] C2={new Color(0,150,150),Color.white,Color.white,Color.white,Color.orange};
	Color[] C={Color.black,Color.red,Color.white,Color.red,Color.white,Color.white,Color.white};
	String[] ColorString={"background","frame","spirals","diagonals","centers","Z invariant","export","display"};
	int[] ColorState={1,1,1,1,1,1,0};
        COLOR=new ControlPanelColor(C0,ColorString,ColorState,7,C);



	String[] NormString={"square","square/ctr","homothety","similarity","normalize"};
	int[] NormState={1,0,0,0};
        NORM=new ControlPanel(C1,NormString,NormState,4);


	String[] SelectString={"random","log","click to select"};
	int[] SelectState={0,0};
        SELECT=new ControlPanel(C2,SelectString,SelectState,2);
    }

    public int getIter() {
	return(I1.val+I2.val);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.blue);
      g.fillRect(0,0,getWidth(),getHeight()); 
      CS.render(g);
      drawControls(g);
   }

    public void drawControls(Graphics2D g) {
      g.setFont(new Font("Helvetica",Font.PLAIN,16));
      S1.render(g,new Color(0,200,200),Color.white,Color.yellow);
      S2.render(g,new Color(0,200,200),Color.white,Color.yellow);

      Color NULL=new Color(0,0,0,0);
      I1.render(g,new Color(255,255,0),NULL,NULL);
      I2.render(g,new Color(255,255,0),NULL,NULL);
      I3.render(g,new Color(100,0,200),Color.white,Color.white);
      D1.render(g,new Color(0,0,220),Color.white,Color.white);
      WIDTH.render(g,Color.white,Color.white,Color.white);
      if(COLOR.L[4].on==1) 
      POINT.render2(g,COLOR.M[4].C,Color.white,Color.white);
      PROJ.render(g,new Color(100,0,200));
      MAP0.render(g,new Color(100,0,200));
      MAP1.render(g,new Color(100,0,200));
      MAP2.render(g,new Color(100,0,200));
      EXPONENT.render(g,new Color(100,0,200));
      if(ANIM.HALT==true) GO.render(g,new Color(0,200,0));
      if(ANIM.HALT==false) STOP.render(g,Color.red);
      COLOR.render(g,0,55,100);
      NORM.render(g,0,430,100);
      SELECT.render(g,200,80,90);
      for(int i=0;i<S2.val;++i) SPIRAL[i].render(g,M.P.COLOR[i]); 
      g.setColor(Color.white);
      Integer N=new Integer(getIter());
      g.drawString("normalize",(int)(PROJ.x+5),(int)(PROJ.y+15));
      g.drawString("inverse map",(int)(MAP0.x+5),(int)(MAP0.y+15));
      g.drawString("map",(int)(MAP1.x+5),(int)(MAP1.y+15));
      g.drawString("map & normalize",(int)(MAP2.x+5),(int)(MAP2.y+15));
      g.drawString("# of steps displayed",(int)(I1.x+3),(int)(I1.y+31));
      if(COLOR.L[4].on==1)
      g.drawString("# center pts.",(int)(POINT.x),(int)(POINT.y+31));
      g.drawString("map exponent",(int)(I3.x+5),(int)(I3.y+32));
      g.drawString("animation delay",(int)(D1.x),(int)(D1.y+32));
      g.drawString("# of spirals",(int)(S2.x),(int)(S2.y+37));
      g.drawString("# of poly sides",(int)(S1.x),(int)(S1.y+37));
      g.drawString("spiral width",(int)(WIDTH.x),(int)(WIDTH.y+26));
      g.drawString("spiral colors",(int)(SPIRAL[0].x),(int)(SPIRAL[0].y+23)); 
      g.drawString("nice power",(int)(EXPONENT.x+5),(int)(EXPONENT.y+15)); 
      g.setFont(new Font("Helvetica",Font.PLAIN,16));
      g.drawString(N.toString(),(int)(I1.x+45),(int)(I1.y+16));
      if(ANIM.HALT==true)
      g.drawString("go",(int)(GO.x+5),(int)(GO.y+15)); 
      if(ANIM.HALT==false)
      g.drawString("stop",(int)(STOP.x+5),(int)(STOP.y+15));

    }

    public void changePoly(Point X) {
	S1.modify(X);
	S2.modify(X);
	if(S2.val>=S1.val) S2.val=S1.val-1;
	int a1=S1.isModified(X);
	int a2=S2.isModified(X);
	int a3=SELECT.getValue(X);
	if(a3==0) M.P.setPolygonRandom(S1.val,S2.val);
	if(a3==1) M.P.setPolygonLog(S1.val,S2.val);

	int q=NORM.mode;
	if(PROJ.inside(X)==1) {
	    M.P.V[0]=Normalize.normalize(q,M.P.V[0],1);
	}
	if(MAP0.inside(X)==1) {
	    int p=I3.val;
	    for(int i=0;i<p;++i)  {
               M.P.V[0]=M.P.V[0].mapInverse();
	    }
	}
	if(MAP1.inside(X)==1) {
	    int p=I3.val;
	    for(int i=0;i<p;++i)  {
               M.P.V[0]=M.P.V[0].map();
	    }
	}
	if(MAP2.inside(X)==1) { 
             int p=I3.val;
	     for(int i=0;i<p;++i) {
		M.P.V[0]=M.P.V[0].map(); 
                M.P.V[0]=Normalize.normalize(q,M.P.V[0],1);
	     }
	}
    }

    public void changeColors(Point X) {
	for(int i=0;i<S2.val;++i) {
	    if(SPIRAL[i].inside(X)==1) M.P.COLOR[i]=CS.C;
	}
    }

    public void action(Point X) {
	if((ANIM.HALT==true)&&(GO.inside(X)==1)) {
	    ANIM=new Animator(this.M);
             new Thread(ANIM).start();
	}

	if((ANIM.HALT==false)&&(STOP.inside(X)==1)) {
	    ANIM.HALT=true;
	}
    }

    public void lookupExponent() {
	int n=M.P.V[0].N;
	int k=M.P.V[0].K;
	if((n==4)&&(k==1)) I3.val=1;
	if((n==4)&&(k==2)) I3.val=2;
	if((n==4)&&(k==3)) I3.val=18;
	if((n==5)&&(k==1)) I3.val=8;
	if((n==5)&&(k==2)) I3.val=25;
	if((n==5)&&(k==3)) I3.val=20;
	if((n==5)&&(k==4)) I3.val=86;
	if((n==6)&&(k==1)) I3.val=16;
	if((n==6)&&(k==2)) I3.val=54;
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	changePoly(J.X);
	changeColors(J.X);
	I1.modify(J.X);
	I2.modify(J.X);
	I3.modify(J.X);
	D1.modify(J.X);
	WIDTH.modify(J.X);
	POINT.modify(J.X);
	if(EXPONENT.inside(J.X)==1) lookupExponent();
	COLOR.process(J.X,CS.C);
	NORM.switchMode(J.X);
	action(J.X);
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     } 

}

