import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Invariants {



    public static double Z(Seed D) {
	double d=1;
	int n=D.N;
	int k=D.K;
	for(int i=0;i<n;++i) {
	    int i1=k+i;
	    int i2=k+i-1;
            d=d*I(D,i1,i2);
	}
	for(int i=0;i<n+k;++i) {
	     int i1=k+n-i-1;
	     int i2=k+n+i-1;  
             d=d*I(D,i1,i2);

	}
	return(d);
    }

    /**This extracts the invariant I(m,k)**/

    public static double I(Seed D,int m,int k) {
	if((m%2==0)&&(k%2==0)) return(I00(D,m,k));
	if((m%2==0)&&(k%2==1)) return(I01(D,m,k));
	if((m%2==1)&&(k%2==0)) return(I10(D,m,k));
	if((m%2==1)&&(k%2==1)) return(I11(D,m,k));
	return(0);
    }


    public static double I00(Seed D,int m,int k) {
	int val=m+(k-m-0)/2-2;
	Seed E=shift(val,D);
	Vector[] T=spiral(E,m,6);
	return(localI(T,2,-1));
    }

    public static double I01(Seed D,int m,int k) {
	int val=m+(k-m-1)/2-2;
	Seed E=shift(val,D);
	Vector[] T=spiral(E,m,6);
	return(localI(T,2,1));
    }


    public static double I10(Seed D,int m,int k) {
	int val=(k+m-1)/2-2;
	Seed E=shift(val,D);
	Vector[] T=spiral(E,m,6);
	return(localI(T,2,1));
    }

    public static double I11(Seed D,int m,int k) {
	int val=(k+m-0)/2-2;
	Seed E=shift(val,D);
	Vector[] T=spiral(E,m,6);
	return(localI(T,2,-1));
    }




    public static Seed shift(int q,Seed E) {
	if(q==0) return(E);
	Seed F=new Seed(E);
	if(q<0) {
	    for(int i=0;i<-q;++i) F=F.mapInverse();
	    return(F);
	}
	for(int i=0;i<q;++i) F=F.map();
	return(F);
    }


    /**This extracts k steps of the mth spiral**/

    public static Vector[] spiral(Seed D,int m,int k) {
	Seed E=new Seed(D);
	for(int i=0;i<2*m;++i) E=E.mapInverse();
	Vector[] W=spiral(E,k+3*m);
	for(int i=0;i<m;++i) W=pentagram(W);
	return(W);
    }



    /**This extracts k steps of the spiral from the seed.*/

    public static Vector[] spiral(Seed D,int k) {
	Vector[] S=new Vector[k];
	Seed E=new Seed(D);
	for(int i=0;i<k;++i) {
	    S[i]=new Vector(E.A[1]);
	    E=E.map();
	}
	return(S);
    }

    /**This routine does the pentagram map on a list of K
       vectors.  The return is K-3 vectors.*/

    public static Vector[] pentagram(Vector[] S) {
	Vector[] T=new Vector[S.length-3];
	for(int i=0;i<T.length;++i) {
	    T[i]=Vector.findCross(S[i+0],S[i+2],S[i+1],S[i+3]);
	    T[i]=T[i].normalize();
	}
	return(T);
    }



    /**vectors should be normalized to have 3rd coordinate equal to 1.*/

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.x[1]-V1.x[1])/(V2.x[0]-V1.x[0]);
        return(s);
    }


    /**inverse of usual cross ratio*/

    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    /**The local invariant.  The first one you can take is
       for j=1,ii=1**/

    public static double localI(Vector[] S,int j,int ii) {
	Vector[] T=new Vector[S.length];
	for(int i=0;i<S.length;++i) {
	    T[i]=rotate(S[i],Math.sqrt(2.0));
	}
	int j1=(j-1*ii);
	int j2=(j-2*ii);
	int j3=(j-0*ii);
	int j4=(j+1*ii);
	int j5=(j+2*ii);
	double ll=fan(T[j1],T[j2],T[j3],T[j4],T[j5]);
        return(ll);
    }

    public static Vector rotate(Vector V,double d) {
	Complex z=new Complex(Math.cos(d),Math.sin(d));
	Complex w=new Complex(V.x[0],V.x[1]);
	w=Complex.times(w,z);
	Vector W=new Vector(w.x,w.y,1);;
	return(W);
    }



}
