import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**this projectively normalizes a polygon*/


public class Normalize {

    /**final routine**/

    public static Seed normalize(int choice,Seed X,int vtx) {
	if(choice==0) {
             Matrix M=normalize3(X,vtx);
	     Seed Y=Seed.act(M,X);
	     Y=Y.normalize();
	     Y.calibrate();
	     return(Y);
	}
	if(choice==1) {
             Matrix M=normalize3(X,vtx);
	     Seed Y=Seed.act(M,X);
	     Y=Y.normalize();
             Y=recenter(Y);
	     Y.calibrate();
	     return(Y);
	}

	if(choice==2) {
	   Seed Y=X.normalize();
           Y=unitize(Y);
	   Y.calibrate();
	   return(Y);
	}

	if(choice==3) {
	   Seed Y=X.normalize();
           Y=rotate(Y);
	   Y.calibrate();
	   return(Y);
	}
	return(X);
    }


    public static Matrix normalize0(Vector V0,Vector V1,Vector V2,Vector V3) {
	Vector[] VV={V0,V1,V2};
	Matrix M=new Matrix(VV);
	M=M.transpose();
	Matrix M2=M.inverse();
	Vector L=Matrix.act(M2,V3);

	for(int i=0;i<3;++i) {
	for(int j=0;j<3;++j) {
	    M.a[i][j]=M.a[i][j]*L.x[j];
	}}

	M=M.inverse();
	return(M);
    }




    public static Matrix normalize0(Seed X,int vtx) {
	return(normalize0(X.A[0+vtx],X.A[1+vtx],X.A[2+vtx],X.A[3+vtx]));
    }

    public static Matrix normalize2() {
	Vector V0=new Vector(0,0,1);
	Vector V1=new Vector(1,0,1);
	Vector V2=new Vector(1,1,1);
	Vector V3=new Vector(0,1,1);
	Matrix M=normalize0(V0,V1,V2,V3);
	return(M);
    }



    public static Matrix normalize3(Seed X,int vtx) {
	Matrix M1=normalize0(X,vtx);
	Matrix M2=normalize2();
	Matrix M=Matrix.times(M2.inverse(),M1);
	return(M);
    }





    /**translates to that the limit point is the center.*/

    public static Seed recenter(Seed X) {
	Seed Y=new Seed(X);
	Vector C=nearCenter(Y);
	for(int i=1;i<=Y.N;++i) {
	    Y.A[i]=Vector.planeMinus(Y.A[i],C);
	    Y.B[i]=Vector.planeMinus(Y.B[i],C);
	}
	return(Y);
    }

    public static Vector nearCenter(Seed P) {
	Seed Q=new Seed(P);
	for(int i=0;i<100;++i) Q=Q.map();
	return(Q.A[1]);
    }


    public static Seed shear(Seed X) {
 	Seed Y=rotate(X);
	double t=(-Y.A[2].x[0])/Y.A[2].x[1];
	for(int i=1;i<=Y.N;++i) {
	    Y.A[i].x[0]=Y.A[i].x[0]+t*Y.A[i].x[1];
	    Y.B[i].x[0]=Y.B[i].x[0]+t*Y.B[i].x[1];
	}
	t=Y.A[2].x[1];
	for(int i=1;i<=Y.N;++i) {
	    Y.A[i].x[1]=Y.A[i].x[1]/t;
	    Y.B[i].x[1]=Y.B[i].x[1]/t;
	}
	return(Y);
    }
    /**Produces the matrix which has the following projective action:

      [V0] -->  [1:0:0]
      [V1] -->  [0:1:0]
      [V2] -->  [0:0:1]
      [V3] -->  [1:1:1]

	 */

    public static double asymptoticShrink(Seed P,long tot) {
	Seed Q=new Seed(P);
	double x=0;
	for(int i=0;i<tot;++i) {
	    Q=Q.map();
	    double r=firstVectorNorm(Q);
	    x=x+Math.log(r);
	    Q=unitize(Q);
	}
	x=x/tot;
	x=Math.exp(x);
	return(x);
    }

    public static Complex asymptoticRotate(Seed P,long tot) {
	double total=asymptoticArg(P,tot);
	Complex z=new Complex(Math.cos(total),Math.sin(total));
	return(z);

    }


    public static double asymptoticArg(Seed P,long tot) {

	Seed Q=new Seed(P);
	double x=0;
	double total=0;
	double a=0;
	for(int i=0;i<tot;++i) {
	    Complex z0=new Complex(Q.A[1].x[0],Q.A[1].x[1]);
	    Complex z1=new Complex(Q.A[2].x[0],Q.A[2].x[1]);
	    Complex z2=Complex.divide(z1,z0);
	    a=Math.atan2(z2.y,z2.x);
	    total=total+a;
	    Q=Q.map();
	    Q=unitize(Q);
	}
	total=total/tot;
	return(total);

    }




     public static Seed unitize(Seed X) {
	Seed Y=new Seed(X);
	Y=recenter(Y);
	double r=firstVectorNorm(X);
	return(scale(1/r,X));
     }

     public static double firstVectorNorm(Seed X) {
	Seed Y=new Seed(X);
	Y=recenter(Y);
	double x0=Y.A[1].x[0];
	double x1=Y.A[1].x[1];
	double r=x0*x0+x1*x1;
	r=Math.sqrt(r);
	return(r);
     }


     public static Seed scale(double r,Seed X) {
	Seed Y=new Seed(X);
	Y=recenter(Y);
	Complex z=new Complex(r,0);
	for(int i=1;i<=Y.N;++i) {
	    Y.A[i]=Vector.planeScale(r,Y.A[i]);
	    Y.B[i]=Vector.planeScale(r,Y.B[i]);
	}
	return(Y);
    }

     public static Seed rotate(Seed X) {
	 Complex z=new Complex(X.A[1].x[0],X.A[1].x[1]);
	 z=z.inverse();
	 return(rotate(z,X));
     }

     public static Seed rotate(Complex z,Seed X) {
	Seed Y=new Seed(X);
	Y=recenter(Y);
	for(int i=1;i<=Y.N;++i) {
	    Complex w=new Complex(Y.A[i].x[0],Y.A[i].x[1]);
	    w=Complex.times(z,w);
	    Y.A[i]=new Vector(w.x,w.y,1);
	    w=new Complex(Y.B[i].x[0],Y.B[i].x[1]);
	    w=Complex.times(z,w);
	    Y.B[i]=new Vector(w.x,w.y,1);
	}
	return(Y);
    }

}




