import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Seed[] V=new Seed[1100];
    Color[] COLOR=new Color[1100];
    Complex[] POINT=new Complex[1100];
    int POINT_COUNT;
    int COUNT;
    int VTX;
    int history;
    Point JX;
    boolean DRAG;


     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(250,550,400);	
	 setPolygonRandom(4,3);
	 history=-1;
	 COUNT=1;
	 POINT_COUNT=0;
	 DRAG=false;
	 for(int i=0;i<100;++i) COLOR[i]=Color.white;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        drawBg(g);
        drawPolygons(g);   
	if(M.C.COLOR.L[4].on==1) drawPoints(g);
	if(M.C.COLOR.L[5].on==1) showInvariant(g); 
        if(M.C.COLOR.L[6].on==1) exportPolygons(); 
        drawSource(g);
   }


   public void drawBg(Graphics2D g) {
          g.setColor(M.C.COLOR.M[0].C);
          g.fillRect(0,0,getWidth(),getHeight());
	  g.setColor(Color.white);
	  g.setFont(new Font("Helvetica",Font.PLAIN,14));
	  g.drawString("keyboard controls:",5,695);
	  g.drawString("z: zoom in",205,695);
	  g.drawString("x: select point",305,695);
	  g.drawString("c: zoom out",415,695);

      }


    public void setPolygonRandom(int n,int k) {
	V[0]=Seed.randomStart(n,k);
    }

    public void setPolygonLog(int n,int k) {
	V[0]=SeedLog.main(n,k);
    }


    public void drawPoints(Graphics2D g) {
	Color C=M.C.COLOR.M[4].C;
	for(int i=0;i<POINT_COUNT;++i) {
	    fillPoint(g,POINT[i],.001,C,16);
	}
    }

    public void drawPolygons(Graphics2D g) {
	int[] a=new int[4];
 	Color[] C=new Color[4];
	for(int i=0;i<4;++i) {
           a[i]=M.C.COLOR.L[i].on;
	   C[i]=M.C.COLOR.M[i].C;
	}


        int w=M.C.WIDTH.val;
	for(int i=0;i<M.C.getIter();++i) {
	    V[i+1]=V[i].map();
	}
	COUNT=M.C.getIter()+1;
	Color C1=M.C.COLOR.M[1].C;

	for(int i=0;i<COUNT;++i) {
	    if(a[1]==1) SeedRender.renderFrame(g,V[i],C[1],this);
	    if(a[2]==1) SeedRender.renderSpirals(g,V[i],COLOR,w,this);
	    if(a[3]==1) SeedRender.renderCross(g,V[i],C[3],this);
	}
    }

    public void showInvariant(Graphics2D g) {
	double z=Invariants.Z(V[0]);
	double z1=-Math.log(z);
	Double Z1=new Double(z1);
	Double Z=new Double(z);
	g.setColor(M.C.COLOR.M[5].C);
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString("Z="+Z.toString(),5,18);
	g.drawString("-log Z="+Z1.toString(),215,18);
	int n=M.C.S1.val+M.C.S2.val;
	double z2=Math.pow(z,1.0/n);
	Double Z2=new Double(z2);
	Integer N=new Integer(n);
	g.drawString(N.toString()+"th root of Z="+Z2.toString(),445,18);

    }


    public void exportPolygons() {
	Output OUT=new Output("Output/data");
	for(int i=0;i<M.C.getIter();++i) {
	    V[i+1]=V[i].map();
	}
	COUNT=M.C.getIter()+1;
	for(int i=0;i<COUNT;++i) {
	    SeedExport.export(OUT,V[i]);
	}
    }

    public void setVertex() {

	int n=V[0].N;
	if(VTX<=n) {
            V[0].A[VTX]=new Vector(SOURCE); 
            V[0].coerce();
	}

 	if(VTX>=n+1) {
	    Complex z=V[0].coerce(VTX-n,SOURCE);
	    V[0].B[VTX-n]=new Vector(z);
	    V[0].calibrate();
	}
    }

    public void findNearest() {
	VTX=V[0].nearestVertex(SOURCE);
    }


    public void mouseClicked(MouseEvent e) {
      MouseData J=MouseData.process(e);
      JX=J.X;
      doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {
        doScale(mode,JX);
	findNearest();	
        if(mode==2) setVertex();
	repaint();
	M.C.repaint();
    }

    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
  	MouseData J=MouseData.process(e);
	JX=J.X;
	if(DRAG==true) {
	    doMouseClick(2);
	}
     }

    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=J.X;
	if(J.mode==2) doMouseClick(2);
    }


    public void keyTyped(KeyEvent e) {
	int test=-100;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	doMouseClick(test);
	repaint();
	M.C.repaint();
    }


    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') DRAG=true;
    }

    public void keyReleased(KeyEvent e) {
	DRAG=false;
    }

}

