import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Seed {
    int K,N;
    Vector[] A=new Vector[100];
    Vector[] B=new Vector[100];
    double[] e=new double[100];


    public Seed() {
	for(int i=0;i<100;++i) {
	    A[i]=new Vector();
	    B[i]=new Vector();
	}
    }

    public Seed(Seed Q) {
	this.N=Q.N;
	this.K=Q.K;
	for(int i=1;i<=N;++i) {
	    this.A[i]=new Vector(Q.A[i]);
	    this.B[i]=new Vector(Q.B[i]);
	    this.e[i]=Q.e[i];
	}
    }


    public static Seed add(Seed P1,Seed P2) {
	Seed Q=new Seed();
	Q.N=P1.N;
	Q.K=P1.K;
	for(int i=1;i<=Q.N;++i) { 
            Q.e[i]=P1.e[i]+P2.e[i];
            Q.A[i]=Vector.planePlus(P1.A[i],P2.A[i]);
            Q.B[i]=Vector.planePlus(P1.B[i],P2.B[i]);
	}
	return(Q);
    }


    public static Seed scale(double r,Seed P) {
	Seed Q=new Seed();
	Q.N=P.N;
	Q.K=P.K;
	for(int i=1;i<=Q.N;++i) { 
            Q.e[i]=r*P.e[i];
            Q.A[i]=Vector.planeScale(r,P.A[i]);
            Q.B[i]=Vector.planeScale(r,P.B[i]);
	}
	return(Q);
    }


    public Seed normalize() {
	Seed P=new Seed();
	P.N=N;
	P.K=K;
	for(int i=1;i<=N;++i) {
	    P.A[i]=A[i].normalize();
	    P.B[i]=B[i].normalize();
	    P.e[i]=e[i];
	}
	return(P);
    }

    public Seed map() {
	Seed Q=new Seed();
	Q.N=N;
	Q.K=K;

	for(int i=1;i<=N-K;++i) {
	    Q.A[i]=new Vector(A[i+1]);
	}

	for(int i=N-K+1;i<=N;++i) {
	    Q.A[i]=new Vector(B[i]);
	}

	Q.B[N]=Vector.findCross(A[1],Q.A[2],Q.A[N],Q.A[1]);
	Q.B[N]=Q.B[N].normalize();

	for(int i=N-1;i>=N-K+1;--i) {
	    Q.B[i]=Vector.findCross(A[i+1],Q.B[i+1],Q.A[i],Q.A[i+1]);
	    Q.B[i]=Q.B[i].normalize();
	}
	Q.calibrate();
	return(Q);
    }

    public Seed mapInverse() {
	Seed Q=new Seed();
	Q.N=N;
	Q.K=K;

	for(int i=2;i<=N-K+1;++i) {
	    Q.A[i]=new Vector(A[i-1]);
	}

	for(int i=N-K+1;i<=N;++i) {
	    Q.B[i]=new Vector(A[i]);
	}

	for(int i=N-K+2;i<=N;++i) {
	    Q.A[i]=Vector.findCross(Q.A[i-1],Q.B[i-1],B[i-1],B[i]);
	    Q.A[i]=Q.A[i].normalize();
	}

	Q.A[1]=Vector.findCross(Q.A[N],Q.B[N],A[2],B[N]);
	Q.A[1]=Q.A[1].normalize();
	Q.calibrate();
	return(Q);
    }


    public static Seed randomStart(int n,int k) {

	Seed X=new Seed();
	X.N=n;
	X.K=k;
	for(int i=1;i<=n;++i) {
	    double j=i+.5;
	    double t=2.0*Math.PI*j/n;
	    X.A[i]=new Vector(Math.cos(t),Math.sin(t));
	    X.e[i]=.25+.5*Math.random();
	}
	X.coerce();
	X=Normalize.normalize(0,X,1);
	return(X);
    }

    public int nearestVertex(Complex z) {
	int index=-1;
	Vector W=new Vector(z);
	double min=1000000.0;
	for(int i=1;i<=N;++i) {
	    double test=W.dist(W,this.A[i]);
	    if(test<min) {
		min=test;;
		index =i;
	    }
	}

	for(int i=1;i<=N;++i) {
	    double test=W.dist(W,this.B[i]);
	    if(test<min) {
		min=test;;
		index =i+N;
	    }
	}


	return(index);
    }




    public void calibrate() {
	for(int i=N-K+1;i<=N;++i) {
            int j=i+1;
	    if(j==N+1) j=1;
	    double d1=Vector.dist(A[i],B[i]);
	    double d2=Vector.dist(A[i],A[j]);
	    this.e[i]=d1/d2;
	}

    }


    public void coerce() {
	for(int i=N-K+1;i<=N;++i) {
	    int j=i+1;
	    if(j==N+1) j=1;
	    Vector W1=Vector.planeScale(1-e[i],A[i]);
	    Vector W2=Vector.planeScale(e[i],A[j]);
	    B[i]=Vector.planePlus(W1,W2);
	}
    }


    public Complex coerce(int a,Complex z) {
	int b1=a;
	int b2=a+1;
	if(b2>N) b2=1;
	Complex w1=A[b1].toComplex();
	Complex w2=A[b2].toComplex();
	Complex z2=Complex.divide(Complex.minus(z,w1),Complex.minus(w2,w1));	  
        if(z2.x<0) return(z);
	if(z2.x>1) return(z);
	Complex z3=new Complex(z2.x,0);
	Complex z4=Complex.plus(w1,Complex.times(z3,Complex.minus(w2,w1)));
	return(z4);
    }







    public Complex invariant() {
	Seed P=this.map();
	Complex z=new Complex(this.invariant0(),P.invariant0());
	return(z);
    }

    public double invariant0() {
	Seed P=Normalize.normalize(0,this,this.N-3);
	P.calibrate();
	return(P.e[this.N]);
    }


    public static Seed act(Matrix M,Seed X) {
	Seed Y=new Seed();
	Y.N=X.N;
	Y.K=X.K;

	for(int i=1;i<=X.N;++i) {
	    Y.A[i]=Matrix.act(M,X.A[i]);
	    Y.B[i]=Matrix.act(M,X.B[i]);
	}

	for(int i=0;i<=Y.N;++i) {
	     Y.e[i]=Y.e[i];
	}


	return(Y);
    }


    public void print() {
	System.out.println("seed");
	System.out.println("A:");
	for(int i=1;i<=N;++i) A[i].print();
	System.out.println("B:");
	for(int i=N-K+1;i<=N;++i) B[i].print();
	System.out.println("ratios");
	for(int i=N-K+1;i<=N;++i) System.out.println(e[i]);
    }
   

}
