import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class SeedExport {

    /**This draws the seed and the auxilliary lines.**/

    public static void export(Output O,Seed X) {
	renderFrame(O,X);
	renderCross(O,X);
	renderSpiral(O,X);
    }

    public static void renderFrame(Output O,Seed X) {
	GeneralPath gp=new GeneralPath();
	int n=X.N;
	for(int i=1;i<=n;++i) {
	    int j=i+1;
	    if(j==n+1) j=1;
	    gp=edgeAA(X,X,i,j);
	    O.lineWrite(gp,new Color(150,150,150),1);
	}
    }


    public static void renderSpiral(Output O,Seed X) {
	GeneralPath gp=new GeneralPath();
	int n=X.N;
	int k=X.K;

	for(int i=1;i<=n-k;++i) {
	    int j=i+1;
	    gp=edgeAA(X,X,i,j);
	    O.lineWrite(gp,Color.black,3);
	}

	for(int i=n-k+1;i<=n;++i) {
            gp=edgeAB(X,X,i,i);
	    O.lineWrite(gp,Color.black,3);
	}
    }


    public static void renderCross(Output O,Seed X) {
	GeneralPath gp=new GeneralPath();
	int N=X.N;
	int K=X.K;
	Seed Y=X.map();
	gp=edgeAA(X,Y,1,2);
        O.lineWrite(gp,new Color(150,150,150),1);
	gp=edgeAA(Y,Y,N,1);  
        O.lineWrite(gp,new Color(150,150,150),1);
	for(int i=N-1;i>=N-K+1;--i) {
	    gp=edgeAB(X,Y,i+1,i+1);
            O.lineWrite(gp,new Color(150,150,150),1);
            gp=edgeAA(Y,Y,i,i+1); 
            O.lineWrite(gp,new Color(150,150,150),1);
	}
    }


    public static GeneralPath edgeAA(Seed P,Seed Q,int a,int b) {
	GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(P.A[a].x[0]),(float)(P.A[a].x[1]));
	gp.lineTo((float)(Q.A[b].x[0]),(float)(Q.A[b].x[1]));
	return(gp);
    }


    public static GeneralPath edgeAB(Seed P,Seed Q,int a,int b) {
	GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(P.A[a].x[0]),(float)(P.A[a].x[1]));
	gp.lineTo((float)(Q.B[b].x[0]),(float)(Q.B[b].x[1]));
	return(gp);
    }



}
