import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This produces the logarithmic pentagram spirals*/

public class SeedLog {


    public static Seed main(int n,int k) {
	Seed T=Seed.randomStart(n,k);
	for(int i=0;i<20;++i) T=average(20,T);
	T=Normalize.normalize(0,T,1);
	return(T);
    }



    /**This routine does k iterates of the orbit and then
       averages the points.*/

    public static Seed average(int k,Seed S) {
	Seed T=new Seed();
	Seed Q=new Seed(S);
	Q=Normalize.normalize(0,Q,1);
	Q.calibrate();
	T.N=Q.N;
	T.K=Q.K;
	for(int i=0;i<k;++i) {
	    T=Seed.add(T,Q);
	    Q=Q.map();
	    Q=Normalize.normalize(0,Q,1);
            Q.calibrate();
	}
	T=T.scale(1.0/k,T);
	T.coerce();
	return(T);
    }


}

