import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class SeedRender {

    /**This draws the seed and the auxilliary lines.**/

    public static void render(Graphics2D g,Seed X,Color C1,Color[] C2,Color C3,PictureCanvas P) {
	int w=P.M.C.WIDTH.val;
	renderFrame(g,X,C1,P);
	renderSpirals(g,X,C2,w,P);
	renderCross(g,X,C3,P);
    }

    public static void renderFrame(Graphics2D g,Seed X,Color C,PictureCanvas P) {
	GeneralPath gp=new GeneralPath();
	g.setColor(C);
	int n=X.N;
	for(int i=1;i<=n;++i) {
	    int j=i+1;
	    if(j==n+1) j=1;
	    gp=edgeAA(X,X,i,j);
            gp=P.transform(gp);
	    g.draw(gp);
	}
    }


    public static void renderSpirals(Graphics2D g,Seed X,Color[] C,int w,PictureCanvas P) {
	GeneralPath gp=new GeneralPath();
	g.setStroke(new BasicStroke(w));
	int n=X.N;
	int k=X.K;

	g.setColor(C[0]);
	for(int i=1;i<=n-k;++i) {
	    int j=i+1;
	    gp=edgeAA(X,X,i,j);
            gp=P.transform(gp);
	    g.draw(gp);
	}

	for(int i=n-k+1;i<=n;++i) {
	    g.setColor(C[i-n+k-1]);
	    gp=edgeAB(X,X,i,i);
            gp=P.transform(gp);
	    g.draw(gp);
	}


	g.setStroke(new BasicStroke(1));
    }

    public static void renderCross(Graphics2D g,Seed X,Color C,PictureCanvas P) {
	GeneralPath gp=new GeneralPath();
	int N=X.N;
	int K=X.K;
	g.setColor(C);
	Seed Y=X.map();
	gp=edgeAA(X,Y,1,2);
        gp=P.transform(gp);
	g.draw(gp);
	gp=edgeAA(Y,Y,N,1);
        gp=P.transform(gp);
	g.draw(gp);
	for(int i=N-1;i>=N-K+1;--i) {
	    gp=edgeAB(X,Y,i+1,i+1);
            gp=P.transform(gp);
	    g.draw(gp);
            gp=edgeAA(Y,Y,i,i+1);
            gp=P.transform(gp);
	    g.draw(gp);
	}
    }

    public static GeneralPath edgeAA(Seed P,Seed Q,int a,int b) {
	GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(P.A[a].x[0]),(float)(P.A[a].x[1]));
	gp.lineTo((float)(Q.A[b].x[0]),(float)(Q.A[b].x[1]));
	return(gp);
    }


    public static GeneralPath edgeAB(Seed P,Seed Q,int a,int b) {
	GeneralPath gp=new GeneralPath();
        gp.moveTo((float)(P.A[a].x[0]),(float)(P.A[a].x[1]));
	gp.lineTo((float)(Q.B[b].x[0]),(float)(Q.B[b].x[1]));
	return(gp);
    }

    public static GeneralPath getSpiral(Vector[] S) {
	int k=S.length;
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<k-1;++i) {
	    gp.moveTo((float)(S[i].x[0]),(float)(S[i].x[1]));
	    gp.lineTo((float)(S[i+1].x[0]),(float)(S[i+1].x[1]));
	}
	return(gp);
    }
		      





}
