(* This file corresponds to Lemma L21 in the book.
    We compute the Hessians of the various energy hybrids and
    then check that the minimum eigenvalues are at least 32.
    When the file is loaded into Mathematica everything 
    relevant to the proof gets printed.*)
   
(*Clears the variables used in the file*)
Clear[IST,f,g,G,D2G,x,y,z,x1,x2,x3,y1,y2,y3];





(**These routines generate the Hessians of the energy hybrids*)

(*inverse stereographic projection*)
IST[x_, y_] := {(2*x)/(1 + x*x + y*y), (2*y)/(1 + x*x + y*y), 1 - 2/(1 + x*x + y*y)};

(*These are the two basic interaction potentials making up the main ...
 energy function*)

f[x1_,y1_,EXP_]:=(
a=IST[x1,y1];
b={0,0,1};
c=(a-b).(a-b);
Power[4-c,EXP])

g[x1_,y1_,x2_,y2_,EXP_]:=(
a=IST[x1,y1];
b=IST[x2,y2];
c=(a-b).(a-b);
Power[4-c,EXP])

(*Here is the energy function*)

G[x0_,x1_,y1_,x2_,y2_,x3_,y3_,EXP_]:=(
list1={f[x0,0,EXP],
f[x1,y1,EXP],
f[x2,y2,EXP],
f[x3,y3,EXP],
g[x0,0,x1,y1,EXP],
g[x0,0,x2,y2,EXP],
g[x0,0,x3,y3,EXP],
g[x1,y1,x2,y2,EXP],
g[x1,y1,x3,y3,EXP],
g[x2,y2,x3,y3,EXP]};
Sum[list1[[j]],{j,1,10}])

(*End generation of energy function*)






(**this function computes the second partials*)

D2G[i_,j_,EXP_]:=(
d=Sqrt[3]/3;
(*The basic expression*)
A=G[x0,x1,y1,x2,y2,x3,y3,EXP];
(*The variable list*)
VAR={x0,x1,y1,x2,y2,x3,y3};
(*The point corresponding to the TBP*)
special={1,0,-d,-1,0,0,d};
(*suitable second derivative*)
a1=D[A,VAR[[i]],VAR[[j]]];
{x0,x1,y1,x2,y2,x3,y3}={1,0,-d,-1,0,0,d};
a2=a1;
Clear[x0,x1,y1,x2,y2,x3,y3];
a2)
(* end of second partial routine*)






(*computes the hessian and its minimum eigenvalues.*)
HESSIAN[k_]:=Table[Table[D2G[i,j,k],{i,1,7}],{j,1,7}];
(* end of Hessian routine*)





(*This prints out everything we want for a given power combo.
    The last variable tells us to scale the polynomial by
    some value.  We do this because we want to scale our last
    polynomial G10^sharp = G10 + 13 G5 + 68 G2 by 1/32.
    The other polys we scale by 1*)
    
    
PrintTheWorks[c1_,k1_,c2_,k2_,c3_,k3_,scale_]:=(
Clear[t,HH,MinEig,POLY1,POLY2];
Print["_________________________________"];
Print[c1," ",k1," ",c2," ",k2," ",c3," ",k3];
HH=c1 HESSIAN[k1] + c2 HESSIAN[k2] + c3 HESSIAN[k3];
MinEig=Min[Eigenvalues[HH]];
Print["Minimum Eigenvalue (numerical)"];
Print[scale MinEig//N];
POLY1=Det[scale HH-u IdentityMatrix[7]];
POLY2=Expand[POLY1//.{u->-t - 39}];
POLY3=Table[POLY2[[j]],{j,1,Length[POLY2]}];
Print["sign check: should be all 1s"];
Print[Sign[POLY3//.t->1]];
Print["_________________________________"];)

(*End of print routine*)





(*Here are the printouts of the eigenvalues of interest*)
PrintTheWorks[1,3,0,0,0,0,1];
PrintTheWorks[1,4,0,0,0,0,1];
PrintTheWorks[1,5,-25,1,0,0,1];
PrintTheWorks[1,6,0,0,0,0,1];
PrintTheWorks[1,10,13,5,68,2,1/32];



