(* This file corresponds to Lemma L22 in the book.
   We compute the partial Kth derivatives of our functions
   for K=3,4,5,6 and get the bounds advertised in Lemma A11223*)
   
(*Clears the variables used in the file*)
Clear[IST,f,g,G,D2G,x,y,z,x1,x2,x3,y1,y2,y3];








(**These routines generate the Hessians of the energy hybrids*)

(*inverse stereographic projection*)
IST[x_, y_] := {(2*x)/(1 + x*x + y*y), (2*y)/(1 + x*x + y*y), 1 - 2/(1 + x*x + y*y)};

(*These are the two basic interaction potentials making up the main ...
 energy function*)

f[x1_,y1_,EXP_]:=(
a=IST[x1,y1];
b={0,0,1};
c=(a-b).(a-b);
Power[4-c,EXP])

g[x1_,y1_,x2_,y2_,EXP_]:=(
a=IST[x1,y1];
b=IST[x2,y2];
c=(a-b).(a-b);
Power[4-c,EXP])

(*Here is the energy function*)

G[x0_,x1_,y1_,x2_,y2_,x3_,y3_,EXP_]:=(
list1={f[x0,0,EXP],
f[x1,y1,EXP],
f[x2,y2,EXP],
f[x3,y3,EXP],
g[x0,0,x1,y1,EXP],
g[x0,0,x2,y2,EXP],
g[x0,0,x3,y3,EXP],
g[x1,y1,x2,y2,EXP],
g[x1,y1,x3,y3,EXP],
g[x2,y2,x3,y3,EXP]};
Sum[list1[[j]],{j,1,10}])

(* end of energy function definition*)








(**This routine computes the partial derivative of the G_EXP
function with respect to a multi-index J and then evaluate at the
point representing the TBP*)

DerBasic[J_,EXP_]:=(
dd=1/Sqrt[3];
(*The basic expression*)
a1=G[x0,x1,y1,x2,y2,x3,y3,EXP];
VAR={x0,x1,y1,x2,y2,x3,y3};
count=1;
Clear[x0,x1,y1,x2,y2,x3,y3];
While[count<=Length[J],{a1=D[a1,VAR[[J[[count]]]]];++count}];
{x0,x1,y1,x2,y2,x3,y3}={1,0,-dd,-1,0,0,dd};
a2=a1;
Clear[x0,x1,y1,x2,y2,x3,y3];
a2)

(*This is the end of the basic derivative function*)








(*Here is the value of the Jth partial derivative of
  the energy hybrid 
   
         c1 G_k1 + c2 G_k2 + c3 G_k3
         
  evaluated at the TBP.  The last variable tells us to
  scale the result.  We need this for our estimates on G10^sharp*)
      
DerHybrid[J_,c1_,k1_,c2_,k2_,c3_,k3_,scale_]:=(
c1 DerBasic[J,k1] scale  +  c2 DerBasic[J,k2] scale + c3 DerBasic[J,k3] scale)
 
(*This is the end of the derivative function for the energy 
    hyrbrids*)


    
    
    
    
    

(*This gets the non-decreasing k-tuples with values in {1,2,3,4,5,6,7}*)
TupleNonDecrease7[k_]:=(
Clear[LIST,TEST,TEST2,LIST2];
LIST=Tuples[Range[7],k];
TEST=Table[NonDecrease[LIST[[j]]],{j,1,Length[LIST]}];
TEST2=Flatten[Position[TEST,0]];
LIST2=Table[LIST[[TEST2[[j]]]],{j,1,Length[TEST2]}];
LIST2)

(*Tests if a sequence is nondecreasing.  Returns 0 if it is nondecreasing*)

Clear[NonDecrease];
NonDecrease[L_]:=(V=L-Sort[L];V.V);

(*End of definintion of non-decreasing k=tuples*)









(*This computes the maximum DIFFth partial derivative 
of the hybrid energy function, evaluated at the TBP*)

MaxDerHybrid[DIFF_,c1_,k1_,c2_,k2_,c3_,k3_,scale_]:=(
LIST=TupleNonDecrease7[DIFF];
DD=Table[DerHybrid[LIST[[j]],c1,k1,c2,k2,c3,k3,scale],{j,1,Length[LIST]}];
Max[Abs[DD]])

(*End of max derivative routine*)







(*This main routine computes the max derivatives and scales them by
the Taylor series multiplier, as in the lemma*)

MaxDerHybridTaylor[DIFF_,c1_,k1_,c2_,k2_,c3_,k3_,scale_]:=(
TAY=Power[7 Power[2,-18],DIFF-3]/(DIFF-3)!;
LIST=TupleNonDecrease7[DIFF];
DD=Table[DerHybrid[LIST[[j]],c1,k1,c2,k2,c3,k3,scale],{j,1,Length[LIST]}];
TAY Max[Abs[DD]])

(*End of the main routine*)







(*This prints out the results of our calculation,
using the main routine*)


PrintBound[DIFF_,c1_,k1_,c2_,k2_,c3_,k3_,scale_]:=(
Clear[MU];
Print["-------------------------------"];
Print["derivative ",DIFF," hybrid ",c1," ",k1," ",c2," ",k2," ",c3," ",k3," scale ",scale];
MU=MaxDerHybridTaylor[DIFF,c1,k1,c2,k2,c3,k3,scale];
Print["derivative"];
Print[MU];
Print[MU//N]
Print["-------------------------------"];
)

(*End of print routine*)







(*This prints out all the derivative bounds for the lemma*)

    Do[{
PrintBound[kk,1,3,0,0,0,0,1];
PrintBound[kk,1,4,0,0,0,0,1];
PrintBound[kk,1,5,-25,1,0,0,1];
PrintBound[kk,1,6,0,0,0,0,1]
PrintBound[kk,1,10,13,5,68,2,1/32];},{kk,3,6}]
    
