import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class CoeffCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;  
    Lever SCALE; 
    Parameter[] P=new Parameter[6];
    ListenSquare INFO;
    Output OUT;
    Point JX;

     public CoeffCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);	 
	 setScales(200,200,100);
	 for(int i=0;i<6;++i) P[i]=new Parameter(2,25+35*i,80,"1");
	 INFO=new ListenSquare(0,0,12,12);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                         RenderingHints.VALUE_ANTIALIAS_ON);
      drawFrame1(g);
      drawLines(g);
      drawCoeff(g);  
      drawFrame2(g); 
      if(M.C.EXPORT.mode==1) exportCoeff(g);    
   }

    public void drawFrame1(Graphics2D g) {
	g.setColor(new Color(30,30,30));
	g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double gp=new Path2D.Double();
	int r0=M.C.RANGE[0].val;
	int r1=M.C.RANGE[1].val;
	gp.moveTo(r0,-100);
	gp.lineTo(r0,+100);
	gp.lineTo(r1,+100);
	gp.lineTo(r1,-100);
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.black);
	g.fill(gp);
    }

    public void drawFrame2(Graphics2D g) {
	int r0=M.C.RANGE[0].val;
	int r1=M.C.RANGE[1].val;
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(r0,-100);
	gp.lineTo(r0,100);
	gp.moveTo(r1,-100);
	gp.lineTo(r1,100);
	gp=transform(gp);
	g.setStroke(new BasicStroke(2));
	g.setColor(new Color(100,200,255));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));



	g.setColor(new Color(0,0,90));
	g.fillRect(0,0,100,300);
	g.setColor(Color.white);
	g.drawRect(0,0,100,300);
	g.setColor(new Color(80,80,80));
	Color[] C=PresetData.colorScheme();
	for(int i=0;i<5;++i) P[i].render(g,C[i]);
	INFO.infoRender(g);
    }


    public void drawLines(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(100,0);
	gp.lineTo(-100,0);
	gp.moveTo(0,100);
	gp.lineTo(0,-100);
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
	int r0=M.C.RANGE[0].val;
	int r1=M.C.RANGE[1].val;

	Color[] COL={new Color(150,150,150),new Color(100,100,100,100),
		     new Color(100,100,100,180),new Color(100,100,100,60)};

	for(int i=-20;i<170;++i) {
	  gp.reset();
	  double r=.1*i;
	  gp.moveTo(r,-200);
	  gp.lineTo(r,200);
	  gp=transform(gp);
	  boolean outside=false;
	  if(r<r0) outside=true;
	  if(r>r1) outside=true;
	  if(outside==false) {
	      g.setColor(COL[1]);
	      if(i%10==0) g.setColor(COL[0]);
	  }
	  if(outside==true) {
	      g.setColor(COL[3]);
	      if(i%10==0) g.setColor(COL[2]);
	  }
	  g.draw(gp);
	}
    }

    public void drawCoeff(Graphics2D g) {
	Color[] C=PresetData.colorScheme();
	Path2D.Double[] gp=getPlots();
	for(int i=0;i<5;++i) {
	    g.setColor(C[i]);
	    gp[i]=transform(gp[i]);
	    g.draw(gp[i]);
	}
    }


    public void exportCoeff(Graphics2D g) {
	OUT=new Output("Output/graph");
	Path2D.Double x=new Path2D.Double();
	for(int i=-20;i<170;++i) {
	  x.reset();
	  x.moveTo(.1*i,-200);
	  x.lineTo(.1*i,200);
	  if(i%10!=0) OUT.lineWrite(x,new Color(220,220,220));
	  if(i%10==0) OUT.lineWrite(x,new Color(150,150,150));
	}

	x.reset();
	x.moveTo(-100,0);
	x.lineTo(+100,0);
	OUT.lineWrite(x,Color.black);
	x.reset();
	x.moveTo(0,-100);
	x.lineTo(0,+100);
	OUT.lineWrite(x,Color.black);


	Path2D.Double[] gp=getPlots();
	for(int i=1;i<5;++i) {
	    int t=50*i-50;
	    OUT.lineWrite(gp[i],new Color(t,t,t));
	}
    }



    public Path2D.Double[] getPlots() {
	Path2D.Double[] gp=new Path2D.Double[6]; 
	for(int k=0;k<5;++k) gp[k]=new Path2D.Double();
	double[] T=new double[5];
	for(int i=0;i<5;++i) {
	    T[i]=P[i].getVal();
	}
	EnergyCombo[] d=M.C.ENG;
	int r1=-2;
	int r2=16;

	for(int i=0;i<=1000;++i) {
	    double t=1.0*i/1000;
	    double s=(1-t)*r1+t*r2;
	    double[] A=M.C.getTarget();
	    double[] e=new double[6];
	    e=ComputeCombo5.coeffList(d,A,s);
	    if(e==null) return null;

	    for(int k=0;k<5;++k) {
	       if(i==0) gp[k].moveTo(s,1.0*T[k]*e[k]);
	       if(i!=0) gp[k].lineTo(s,1.0*T[k]*e[k]);
	    }
	}
	return gp;
    }


    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) {  
       MouseData J=MouseData.process(e);
       for(int i=0;i<6;++i) P[i].process(e);
       if(J.X.x>100) {
         if(J.mode==3) scaleUp(J.X,1);
         if(J.mode==1) scaleUp(J.X,-1);
       }
       if(INFO.inside(J.X)==1) DocumentCoeff.main(M.D);
       M.repaint();
    }

    public void doMouseClick(int mode,Point X) {
       if(X.x>100) {
         if(mode==3) scaleUp(X,1);
         if(mode==1) scaleUp(X,-1);
       }
       if(INFO.inside(X)==1) DocumentCoeff.main(M.D);
       M.repaint();
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
  	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {
     }

    public void mouseMoved(MouseEvent e) {  
        MouseData J=MouseData.process(e);
	JX=J.X;
    }

    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) { 
	for(int i=0;i<6;++i) P[i].processKey(false,e);
	char ch=e.getKeyChar();
	int mode=0;
	if(ch=='z') mode=1;
	if(ch=='x') mode=2;
	if(ch=='c') mode=3;
	if(ch=='b') mode=1;
	if(ch=='n') mode=2;
	if(ch=='m') mode=3;
	doMouseClick(mode,JX);
	repaint();
    }
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}


}

