import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;



public class ComputeCombo5 {

    public static double[] getTarget(double[] A,double s) {
	double a=A[0];
	double b=A[1];
	double c=A[2];
	double[] T={SpecialFunctions.R(s,a),SpecialFunctions.R(s,b),
                    SpecialFunctions.R(s,c),-SpecialFunctions.dR(s,a)*a,
		    -SpecialFunctions.dR(s,b)*b};
	return T;
    }


    /**This is the main routine.  It gets the coefficients
       a0,a1,a2,a3,a4 of the interpolation*/

    public static double[] coeffList(EnergyCombo[] d,double[] A,double s) {
	Matrix M=getMatrix(d,A);
	M=Matrix.inverse(M);
	double[] T=getTarget(A,s);
	double[] e=new double[5];
	for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
		e[i]=e[i]+M.m[j][i]*T[j];
	    }
	}
	return e;
    }

    public static Matrix getMatrix(EnergyCombo[] d,double[] A) {
	Matrix M=new Matrix();
 	M.size=5;
	double a=A[0];
	double b=A[1];
	double c=A[2];
	for(int i=0;i<5;++i) {
	    M.m[i][0]=SpecialFunctions.G(d[i],a);
	    M.m[i][1]=SpecialFunctions.G(d[i],b);
	    M.m[i][2]=SpecialFunctions.G(d[i],c);
	    M.m[i][3]=-SpecialFunctions.dG(d[i],a)*a;
	    M.m[i][4]=-SpecialFunctions.dG(d[i],b)*b;
	}
	return M;
    }

    /**This gets the value of the linear combination*/

    public static double cone(double[] a,EnergyCombo[] b,double x) {
	double t=0;
	for(int i=0;i<5;++i) t=t+a[i]*SpecialFunctions.G(b[i],x);
	return t;
    }


}



