import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

/**Some basic mathematical functions*/

public class MathHelp {


    /**Gets the long nearest the integer.  Fails if x is not
       really an integer.*/

    public static long nearestLong(double x) {
	long a=(long)(x);
	long index=-2;
	double min=10;
	for(long i=-2;i<=2;++i) {
	    double test=Math.abs(x-a-i);
	    if(test<min) {
		min=test;
		index=i;
	    }
	}
	if(min>.0001) {
	    System.out.println("error: improper conversion");
	    System.out.println("double "+x);
	    System.out.println(a+index);
	    System.out.println("min");
	    throw new ProofException("");
	}
	return(a+index);
    }

    public static long[][] nearestLong(Matrix M,int size) {
	long[][] m=new long[size][size];
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		m[i][j]=nearestLong(M.m[i][j]);
	    }
	}
	return m;
    }

    /**Converts an energy combo to an integer array*/

    public static long[][] nearestLong(EnergyCombo d) {
	long[][] e=new long[3][2];
	for(int i=0;i<3;++i) {
	    for(int j=0;j<2;++j) {
		e[i][j]=nearestLong(d.E[i][j].getVal());
	    }
	}
	return e;
    }

    /**assumes you have a square array*/
    public static long GCD(long[][] m) {
	long g=m[0][0];
	int l=m.length;
	for(int i=0;i<l;++i) {
	    for(int j=0;j<l;++j) {
		g=GCD(g,m[i][j]);
	    }
	}
	return g;
    }


    /**divides by the GCD*/

    public static long[][] reduce(long[][] m) {
	long g=GCD(m);
	int s1=m.length;
	int s2=m[0].length;
	long[][] n=new long[s1][s2];
	for(int i=0;i<s1;++i) {
	    for(int j=0;j<s2;++j) {
		n[i][j]=m[i][j]/g;
	    }
	}
	return n;
    }

    /**negates whole array*/

    public static long[][] negate(long[][] m) {
	int s1=m.length;
	int s2=m[0].length;
	long[][] n=new long[s1][s2];
	for(int i=0;i<s1;++i) {
	    for(int j=0;j<s2;++j) {
		n[i][j]=-m[i][j];
	    }
	}
	return n;
    }

    /**prints out an array of longs*/

    public static void print(long[][] m) {
	int s1=m.length;
	int s2=m[0].length;
	long[][] n=new long[s1][s2];
	for(int i=0;i<s1;++i) {
	    for(int j=0;j<s2;++j) {
		System.out.print(m[i][j]+" ");
	    }
	    System.out.println("");
	}
    }

    /**This computes the greatest common divisor, without the coefficients.**/

    public static long GCD(long a,long b) {
      long u,v,g;
      long u1,v1,g1;
      long t1,t2,t3;
      long q;
      u = 1;  
      v = 0;  
      g = a;
      u1= 0;  
      v1= 1;  
      g1= b;
      while (g1 != 0) {
        q = g/g1; 
        t1= u - q*u1;   
        t2= v - q*v1;   
        t3= g - q*g1;
        u = u1;   
        v = v1;    
        g = g1;
        u1= t1;    
        v1= t2;    
        g1= t3;
      }
      return g;
    }

}



