import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


/**This class does matrix algebra for up to 10x10 cases.*/

public class Matrix {
    double[][] m=new double[10][10];
    int size; 
    int[] data=new int[2];  //for Gaussian elimination

    public Matrix() {}


    public Matrix(Matrix m) {
	this.size=m.size;
	this.data=m.data;
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		this.m[i][j]=m.m[i][j];
	    }
	}
    }

    public static Matrix identity(int s) {
	Matrix M=new Matrix();
	M.size=s;
	for(int i=0;i<s;++i) {
	    for(int j=0;j<s;++j) {
		M.m[i][j]=0;
		if(i==j) M.m[i][j]=1;
	    }
	}
	return(M);
    }

    /**Matrix transpose*/

    public Matrix transpose() {
	Matrix M=new Matrix();
	M.size=this.size;
	for(int i=0;i<size;++i) {
	    for(int j=0;j<size;++j) {
		M.m[j][i]=this.m[i][j];
	    }
	}
	return(M);
    }

    /**inverse*/
    public static Matrix inverse(Matrix m) {
	Matrix[] M=new Matrix[2];
	M[0]=new Matrix(m);
	M[0].data[0]=0;
	M[0].data[1]=0;
	M[1]=identity(m.size);
	for(int i=0;i<m.size;++i) {
           M=GaussianElimination.step(M);
	}
	if(M==null) return(null); //singular matrix
	for(int i=0;i<m.size;++i) {
	    for(int j=0;j<m.size;++j) {
		M[1].m[i][j]=M[1].m[i][j]/M[0].m[i][i];
	    }
	}
	return(M[1]);
    }

    public static double det(Matrix M) {
	Matrix m=new Matrix(M);
	m.data[0]=0;
	m.data[1]=0;
	for(int i=0;i<m.size;++i) m=GaussianElimination.step(m);
	double d=1;
	for(int i=0;i<m.size;++i) d=d*m.m[i][i];
	if(m.data[1]%2==1) d=-d;
	return(d);
    }

    public static Matrix scale(Matrix M0,double d) {
	Matrix M=new Matrix();
	M.size=M0.size;
	for(int i=0;i<M0.size;++i) {
	    for(int j=0;j<M0.size;++j) {
		M.m[i][j]=M0.m[i][j]*d;
	    }
	}
	return M;
    }

}
