import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is a single variable polynomial*/

public class Poly1Interval {
    BigRationalInterval[] C=new BigRationalInterval[16];
    int degree;

    public Poly1Interval() {
	degree=0;
	for(int i=0;i<16;++i) C[i]=BigRationalInterval.zero();
    }

    public Poly1Interval scale(BigRational R) {
	Poly1Interval P=new Poly1Interval();
	P.degree=this.degree;
	for(int i=0;i<=degree;++i) {
	    P.C[i]=this.C[i].scale(R);
	}
	P.degree=this.degree;
	return P;
    }

    public Poly1Interval add(Poly1Interval A) {
	Poly1Interval P=new Poly1Interval();
	for(int i=0;i<16;++i) {
	    P.C[i]=this.C[i].add(A.C[i]);
	}
	P.degree=A.degree;
	if(P.degree<this.degree) P.degree=this.degree;
	return P;
    }

    public Poly1Interval subtract(Poly1Interval A) {
	Poly1Interval P=new Poly1Interval();
	for(int i=0;i<16;++i) {
	    P.C[i]=this.C[i].subtract(A.C[i]);
	}
	P.degree=A.degree;
	if(P.degree<this.degree) P.degree=this.degree;
	return P;
    }

    public Poly1 min() {
	Poly1 Q=new Poly1();
	Q.degree=this.degree;
	for(int i=0;i<=Q.degree;++i) {
	    Q.C[i]=new BigRational(C[i].L);
	}
	return Q;
    }

    public Poly1 max() {
	Poly1 Q=new Poly1();
	Q.degree=this.degree;
	for(int i=0;i<=Q.degree;++i) {
	    Q.C[i]=new BigRational(C[i].R);
	}
	return Q;
    }



    /** NEW(x) = x OLD(x)*/

    public void shiftUp() {
	++degree;
	for(int i=degree;i>0;--i) {
	    C[i]=new BigRationalInterval(C[i-1].L,C[i-1].R);
	}
	C[0]=BigRationalInterval.zero();
    }

    public void printN() {
	System.out.println("-------------------");
	for(int i=0;i<=degree;++i) {
	    C[i].printN();
	    System.out.print(" x^"+i);
	    if(i<degree) System.out.println(" + ");
	    if(i==degree) System.out.println("");
	}
	System.out.println("-------------------");
    }

}


    

