import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



public class PresetData {


    /**The colors for the coefficient displays*/

    public static Color[] colorScheme() {
	Color[] C={new Color(0,255,0),
                   new Color(255,255,0),
                   new Color(255,0,255),
                   new Color(80,160,255),
                   new Color(255,80,0),
		   new Color(250,250,250)};
	return C;
    }

    public static Color[] colorScheme2() {
	Color[] C={new Color(255,255,0),
                   new Color(255,0,255),
                   new Color(80,160,255),
                   new Color(255,80,0),
		   Color.white};
	return C;
    }



    /**Original case of Tumanov's Lemma*/
    public static void preset0(EnergyCombo[] ENG) {
	String[] S={"0","1","2","3","5","1"};
	for(int i=0;i<6;++i) {
               ENG[i].E[0][0].S="1";
               ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               ENG[i].E[1][0].S="0";
               ENG[i].E[1][1].S="1";
               ENG[i].E[2][0].S="0";
               ENG[i].E[2][1].S="1";
	}
    }

    /**Original case of Tumanov's Lemma*/
    public static void preset0(Manager M) {
	String[] S={"0","1","2","3","5","1"};
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[0][0].S="1";
               M.C.ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[1][0].S="0";
               M.C.ENG[i].E[1][1].S="1";
               M.C.ENG[i].E[2][0].S="0";
               M.C.ENG[i].E[2][1].S="1";
	}
	String[] T={"1","2","100","1000","10000","1"};
	scales(M,T);
        M.C.RANGE[0].val=-2;
	M.C.RANGE[1].val=0;
    }


    /**The main case from the paper: getting the exponents in
       the range of [0,6].*/
    public static void preset1(Manager M) {
	String[] S={"0","1","2","4","6","1"};
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[0][0].S="1";
               M.C.ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[1][0].S="0";
               M.C.ENG[i].E[1][1].S="1";
               M.C.ENG[i].E[2][0].S="0";
               M.C.ENG[i].E[2][1].S="1";
	}
	String[] T={"1","80","200","2000","10000","1"};
	scales(M,T);
	M.C.RANGE[0].val=0;
	M.C.RANGE[1].val=6; 
    }




    /**This case gets the interval [3,13]*/

    public static void preset2(Manager M) {
	String[] S={"0","1","2","5","10","1"};
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[0][0].S="1";
               M.C.ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[1][0].S="0";
               M.C.ENG[i].E[1][1].S="1";
               M.C.ENG[i].E[2][0].S="0";
               M.C.ENG[i].E[2][1].S="1";
	}
	M.C.ENG[4].E[1][0].S="28";
	M.C.ENG[4].E[1][1].S="5";
	M.C.ENG[4].E[2][0].S="102";
	M.C.ENG[4].E[2][1].S="2";

	String[] T={"500","500","500","5000","500000","1000"};
	scales(M,T);
        M.C.RANGE[0].val=6;
	M.C.RANGE[1].val=13;
    }

    /**This case gets the interval [6,15.05], but not all
       energies work for the TBP.*/

    public static void preset3(Manager M) {
	String[] S={"0","1","2","5","10","1"};
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[0][0].S="1";
               M.C.ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               M.C.ENG[i].E[1][0].S="0";
               M.C.ENG[i].E[1][1].S="1";
               M.C.ENG[i].E[2][0].S="0";
               M.C.ENG[i].E[2][1].S="1";
	}

	M.C.ENG[4].E[1][0].S="13";
	M.C.ENG[3].E[1][0].S="-25";
	M.C.ENG[3].E[2][0].S="1";
	M.C.ENG[4].E[1][1].S="5";
	M.C.ENG[4].E[2][0].S="68";
	M.C.ENG[4].E[2][1].S="2";

	String[] T={"5000","500","15000","20000","500000","1000"};
        scales(M,T);
        M.C.RANGE[0].val=13;
	M.C.RANGE[1].val=16;
    }


    public static void scales(Manager M,String[] T) {
	try{
	  for(int i=0;i<6;++i) M.X.P[i].S=T[i];
	}
	catch(Exception e) {}
    }


}


