import java.math.*;

public class TaylorSeries2 {

    /**This is the routine which ultimately produces the functions psi and psi'
       from Chapter 8 of the paper.  Here psi is the numerator of the logaritmic
       derivative of the function (+/-)(1-Gamma/F).  These are used in the simple
       root test.*/


    public static Poly2 psi(int r1,int r2,int apx,EnergyCombo[] ENG) {
	long[][] m0=GenerateCoeffs.spread(ENG);
	long[][] m1=GenerateCoeffs.derive1(m0);
	return makePoly(r1,r2,apx,m0,m1);
    }

    public static Poly2 psiDiff(int r1,int r2,int apx,EnergyCombo[] ENG) {
	long[][] m0=GenerateCoeffs.spread(ENG);
	long[][] m1=GenerateCoeffs.derive1(m0);
	long[][] dm0=GenerateCoeffs.derive2(m0);
	long[][] dm1=GenerateCoeffs.derive2(m1);
	return makePoly(r1,r2,apx,dm0,dm1);
    }


    /**The variables r1,r2 specify the interval. For instance 
       2,1 is the interval [2,3] and 
       2,0 is the interval [1,2].
       The variable apx (0 or 1) gives under or over approximation
       The array m0 is the spread array.
       The array m1 is the derived version of the spread array. 
       m0 represents the function F.
       m1 represents the function r F'
       The function we want is PHI(s)=s F + r F'.
       Here s = t + r1  when r2=1 
        and s =-t + r1  when r2=0
        t is the local variable in [0,1].
    */


    public static Poly2 makePoly(int r1,int r2,int apx,long[][] m0,long[][] m1) {
	Poly1Interval[] P=new Poly1Interval[15];

	for(int i=0;i<15;++i) {
	    long[] M0=rowPad(m0,i);
	    long[] M1=rowPad(m1,i);
            Poly1Interval A=TaylorSeries.combo(M0,r1,r2);
            Poly1Interval B=TaylorSeries.combo(M1,r1,r2);
            Poly1Interval A1=A.scale(new BigRational(r1,1));  
            A.shiftUp(); 
	    if(r2==1) {
	       P[i]=B.add(A);
	       P[i]=P[i].add(A1);
	    }
	    else {
	       P[i]=B.subtract(A);
	       P[i]=P[i].add(A1);
	    }

	}
	Poly1[] Q=new Poly1[15];
	for(int i=0;i<15;++i) {
	    if(apx==0) Q[i]=P[i].min();
	    else {Q[i]=P[i].max();}
	}
	Poly2 P2=new Poly2(Q);
	P2=P2.scale(new BigRational(1,1),new BigRational(4,1));

        P2.LEFTX=new BigRational(0,1);
	P2.RIGHTX=new BigRational(1,1);
	P2.LEFTY=new BigRational(0,1);
	P2.RIGHTY=new BigRational(1,1);
	P2.c0=r1;
        P2.c1=r2;
	return P2;
    }

    public static long[] rowPad(long[][] m,int j) {
	long[] Y=new long[6];
	for(int i=0;i<5;++i) Y[i]=m[j][i];
	Y[5]=0;
	return Y;
    }


}

