import java.math.*;

public class TestPosdom1 implements Runnable {
    Manager M;
    boolean HALT;


    public TestPosdom1() {
	HALT=true;
    }

    public TestPosdom1(Manager m) {
	this.M=m;
	HALT=true;
    }


    public void run() {
	HALT=false;
	Poly1[] P=makePolyList();
	int mode=M.C.PROOF1.mode;
	if(mode==0) mainTest(P,false);
	if(mode==1) mainTest(P,true);
	if(mode==2) {
	    for(int i=0;i<P.length;++i) P[i].printN();
	}
	if(mode==3) {
	    for(int i=0;i<P.length;++i) P[i].print();
	}
	HALT=true;
	M.C.repaint();
    }


    public static int[][] getRange(int a0,int b0) {
	if((a0<0)&&(b0>0)) throw new ProofException("mixed interval not allowed");
	int a=a0;
	int b=b0;
	if((a0+2)%2==1) ++a;
	if((b0+2)%2==1) --b;
	int count=0;
	int[][] list= new int[b0-a0][2];

	for(int i=a;i<=b;i=i+2) {
	    for(int j=0;j<2;++j) {
	      boolean test=true;
	      if((i==a)&&((2+a0)%2==0)&&(j==0)) test=false;
	      if((i==b)&&((2+b0)%2==0)&&(j==1)) test=false;
	      if(test==true) {
		list[count][0]=i;
		list[count][1]=j;
		++count;
	      }
	    }
	}
	int[][] list2=new int[count][2];
	for(int i=0;i<count;++i) {
	    list2[i][0]=list[count-i-1][0];
	    list2[i][1]=list[count-i-1][1];
	}
	return list2;
    }


    public int[] getList() {
	int[] list=new int[5];
	int count=0;
	if(M.C.DIFF2.on==1) {
	    list[0]=5;
	    ++count;
	}

	for(int i=1;i<5;++i) {
	    if(M.C.ENG[i].Z2.on==1) {
		list[count]=i;
		if(i==0) list[count]=5;
		++count;
	    }
	}
	int[] list2=new int[count];
	for(int i=0;i<count;++i) list2[i]=list[i];
	return list2;
    }




    public Poly1[] makePolyList() {
	int a=M.C.RANGE[0].val;
	int b=M.C.RANGE[1].val;
	int[][] range=getRange(a,b);
	int[] list=getList();
	int num=list.length*(b-a);
	System.out.println("number of functions "+num);
	Poly1[] P=new Poly1[num];
	int count=0;
	for(int k=0;k<list.length;++k) {
  	    for(int i=0;i<b-a;++i) {
		P[count]=makePoly(list[k],range[i][0],range[i][1]);
		++count;
	    }
	}
	return P;
    }


    /**In the negative case we reverse the sign*/

    public long[] signFix(long[] Y0) {
	if(M.C.RANGE[0].val>=0) return Y0;
	long[] Y={-Y0[0],-Y0[1],-Y0[2],-Y0[3],-Y0[4],-Y0[5]};
	return Y;
    }

    /**This is to test that the combo is negative at r=0 in the
       negative case.   We have to manually insert this into the
       code to run it.*/

    public long[] specialChoice() {
	long[] Y={0,0,0,0,0,0};
	long[][] YY=new long[5][6];
	for(int i=0;i<5;++i) {
	   YY[i]=GenerateCoeffs.getRow(M.C.ENG,i);
       }
       long[] CC={1,4,16,256,1024};
	for(int i=0;i<5;++i) {
	    for(int j=0;j<6;++j) {
		Y[j]=Y[j]-CC[i]*YY[i][j];
	    }
	}
	return Y;
    }



    public Poly1 makePoly(int choice,int cen,int alt) {
	long[] Y=GenerateCoeffs.getRow(M.C.ENG,choice);
	Y=signFix(Y);

	/**special choice: uncomment the next line to run the special choice.*/
        /**Y=specialChoice();*/

	Poly1 P=TaylorSeries.mainMin(Y,cen,alt);  //under approx
	if(alt==0) P=P.reverse();

	int cen1=cen;
	int cen2=cen+1;
	if(alt==0) {
            cen1=cen-1;
            cen2=cen;
	}

	P.LEFT=new BigRational(cen1,1);
	P.RIGHT=new BigRational(cen2,1);
	return P;
    }

    /**mode decides whether we do the extra reverse*/

    public void mainTest(Poly1[] LIST,boolean mode) {
	BigRational CUTOFF=new BigRational(301,20);
	int count=0;
	System.out.println("----START-------");

	while((HALT==false)&&(LIST.length!=0)) {
	    ++count;
	    Poly1 Q=LIST[LIST.length-1];
	    boolean test=Q.isPositiveDominant();

	    if(test==true) {
		printPosdom(Q);
                LIST=diminish(LIST); 
	    }
	    if(test==false) {
		BigRational TEST=Q.LEFT.subtract(CUTOFF);
		if(TEST.isNegative()==true) {
		   LIST=augment(LIST,mode);
		   printFail(Q);
		}
		else {
		    LIST=diminish(LIST);
		    printOutOfRange(Q);
		}
	    }
	    if(Q.age>30) HALT=true;
	}
        if(HALT==false) System.out.println("----PASS------");
	else System.out.println("****FAIL******");
	HALT=true;
	M.repaint();
    }

    public static void printPosdom(Poly1 Q) {
	System.out.print("positive dominant ");
	Q.printEndpoints();
    }
    public static void printOutOfRange(Poly1 Q) {
	System.out.print("out of range");
	Q.printEndpoints();
    }

    public static void printFail(Poly1 Q) {
    }


    public static Poly1[] diminish(Poly1[] LIST1) {
	Poly1[] LIST2=new Poly1[LIST1.length-1];
	int n=LIST1.length;
	for(int i=0;i<n-1;++i) LIST2[i]=new Poly1(LIST1[i]);
	return LIST2;
    }


    public static Poly1[] augment(Poly1[] LIST1,boolean mode) {
	Poly1[] LIST2=new Poly1[LIST1.length+1];
	int n=LIST1.length;
	Poly1 Q=LIST1[n-1];
	for(int i=0;i<n-1;++i) LIST2[i]=new Poly1(LIST1[i]);
	LIST2[n-1]=Q.sub2(mode);
	LIST2[n-0]=Q.sub1();
	return LIST2;
    }

}



