import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class GaussianElimination {


    /**This does a single step of Gaussian elimination
       for a single matrix*/

    public static Matrix step(Matrix M) {
	int s=M.data[0];
	int n=M.size;
	double max=0;
	int index=-1;

	for(int i=s;i<n;++i) {
	    double test=Math.abs(M.m[i][s]);
	    if(max<test) {
		index=i;
		max=test;
	    }
	}

	Matrix N=new Matrix(M);
	N.data[0]=M.data[0]+1;
	N.data[1]=M.data[1];
	if(index!=0) {
	    N.m[s]=M.m[index];
	    N.m[index]=M.m[s];
	    ++N.data[1];
	}
	for(int i=0;i<n;++i) {
	    if(i!=s) {
		double d=N.m[i][s]/N.m[s][s];
	        for(int j=s;j<n;++j) {
		    N.m[i][j]=N.m[i][j]-d*N.m[s][j];
		}
	    }
	}
	return(N);
    }

    /**This does a single step of Gaussian elimination
       for a pair of matrices.  The first matrix controls
       the pivot data*/


    public static Matrix[] step(Matrix[] M) {
	if(M==null) return(null);
	int s=M[0].data[0];
	int n=M[0].size;
	double max=0;
	int index=-1;

	for(int i=s;i<n;++i) {
	    double test=Math.abs(M[0].m[i][s]);
	    if(max<test) {
		index=i;
		max=test;
	    }
	}

	if(index==-1) return(null);  //singular matrix

	Matrix[] N=new Matrix[2];
	N[0]=new Matrix(M[0]);
	N[1]=new Matrix(M[1]);
	N[0].data[0]=M[0].data[0]+1;
	N[0].data[1]=M[0].data[1];
	if(index!=0) {
	    N[0].m[s]=M[0].m[index];
	    N[0].m[index]=M[0].m[s];
	    N[1].m[s]=M[1].m[index];
	    N[1].m[index]=M[1].m[s];
	    ++N[0].data[1];
	}
	for(int i=0;i<n;++i) {
	    if(i!=s) {
		double d=N[0].m[i][s]/N[0].m[s][s];
	        for(int j=0;j<n;++j) {
		    N[0].m[i][j]=N[0].m[i][j]-d*N[0].m[s][j];
		    N[1].m[i][j]=N[1].m[i][j]-d*N[1].m[s][j];
		}
	    }
	}
	return(N);
    }



}




