import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



public class PresetData {

    /**This file contains the preset energy combos used in
       the Forcing Lemma*/

    public static EnergyCombo[] preset(int q) {
	if(q==0) return preset0();
	if(q==1) return preset1();
	if(q==2) return preset2();
	if(q==3) return preset3();
	return null;
    }



    /**Original case of Tumanov's Lemma*/
    public static EnergyCombo[] preset0() {
	EnergyCombo[] ENG=new EnergyCombo[6];
	String[] S={"0","1","2","3","5","1"};
	for(int i=0;i<6;++i) { 
            ENG[i]=new EnergyCombo();
            ENG[i].E[0][0].S="1";
            ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
            ENG[i].E[1][0].S="0";
            ENG[i].E[1][1].S="1";
            ENG[i].E[2][0].S="0";
            ENG[i].E[2][1].S="1";
	}
	for(int i=0;i<6;++i) {
	   ENG[i].RANGE[0]=-2;
	   ENG[i].RANGE[1]=0; 
	}
	return ENG;
    }



    /**The main case from the paper: getting the exponents in
       the range of [0,6].*/
    public static EnergyCombo[] preset1() {
	EnergyCombo[] ENG=new EnergyCombo[6];
	String[] S={"0","1","2","4","6","1"};
	for(int i=0;i<6;++i) {
	    ENG[i]=new EnergyCombo();
            ENG[i].E[0][0].S="1";
            ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
            ENG[i].E[1][0].S="0";
            ENG[i].E[1][1].S="1";
            ENG[i].E[2][0].S="0";
            ENG[i].E[2][1].S="1";
	}
	String[] T={"1","80","200","2000","10000","1"};
	for(int i=0;i<6;++i) {
	   ENG[i].RANGE[0]=0;
	   ENG[i].RANGE[1]=6; 
	}
	return ENG;
    }




    /**This case gets the interval [3,13]*/

    public static EnergyCombo[] preset2() {
	EnergyCombo[] ENG=new EnergyCombo[6];
	String[] S={"0","1","2","5","10","1"};
	for(int i=0;i<6;++i) {
	    ENG[i]=new EnergyCombo();
            ENG[i].E[0][0].S="1";
            ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
             ENG[i].E[1][0].S="0";
             ENG[i].E[1][1].S="1";
             ENG[i].E[2][0].S="0";
             ENG[i].E[2][1].S="1";
	}
	ENG[4].E[1][0].S="28";
	ENG[4].E[1][1].S="5";
	ENG[4].E[2][0].S="102";
	ENG[4].E[2][1].S="2";
	for(int i=0;i<6;++i) {
	   ENG[i].RANGE[0]=6;
	   ENG[i].RANGE[1]=13; 
	}
	return ENG;
    }

    /**This case gets the interval [6,15.05], but not all
       energies work for the TBP.*/

    public static EnergyCombo[] preset3() {
	EnergyCombo[] ENG=new EnergyCombo[6];
	String[] S={"0","1","2","5","10","1"};
	for(int i=0;i<6;++i) {
	    ENG[i]=new EnergyCombo();
               ENG[i].E[0][0].S="1";
               ENG[i].E[0][1].S=S[i];
	}
	for(int i=0;i<6;++i) {
               ENG[i].E[1][0].S="0";
               ENG[i].E[1][1].S="1";
               ENG[i].E[2][0].S="0";
               ENG[i].E[2][1].S="1";
	}

	ENG[4].E[1][0].S="13";
	ENG[3].E[1][0].S="-25";
	ENG[3].E[2][0].S="1";
	ENG[4].E[1][1].S="5";
	ENG[4].E[2][0].S="68";
	ENG[4].E[2][1].S="2";
	for(int i=0;i<6;++i) {
	   ENG[i].RANGE[0]=13;
	   ENG[i].RANGE[1]=16; 
	}
	return ENG;
    }
}


