import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class operates our annealing routine which flows any given
configuration towards a minimum.  Basically, we start with a configuration
and test several nearby configurations.  If the configuration can move to
a lower energy configuration that we've tested, it makes the move.
So many little steps are taken that the result looks like a flow.
This class has nothing to do with the proof.  It is just for fun.**/


public class Anneal implements Runnable {
    boolean HALT;
    Manager M;

    public Anneal() {
	HALT=true;
    }

    public Anneal(Manager MM) {
	this.M=MM;
	HALT=true;
    }


    /**This is the main routine**/

    public void run() {
	HALT=false;
	int[][] E=M.C.getEnergy();
	while(HALT==false) {	
	    M.P.Z=replace(E,M.P.Z);
	    M.P.repaint();
	    M.C.repaint();
	}
    }

    /**This moves the qth point*/

    public  Complex[] move(int q,Complex[] Z,Complex w) {
	Complex [] W=new Complex[4];
	for(int i=0;i<4;++i) {
	    W[i]=new Complex(Z[i]);
	}
        W[q]=Complex.plus(Z[q],w);
	return(W);
    }


    /** routine produces a complex number with norm t and argument 2Pi i/n**/

    public  Complex perturb(int i,int n,double t) {
	double Pi=Math.PI;
	double c=Math.cos(2*Pi*i/n);
	double s=Math.sin(2*Pi*i/n);
	c=c*t;
	s=s*t;
	return(new Complex(c,s));
    }


    /**This is the main routine.  We try to move each of the 4 points of Z in 
       one of 4 directions.  We make the move if we arrive at a lower energy. 
       The value t specifies the jumpsize.*/

    public  Complex[] replace(int[][] E,Complex[] Z,double t) {
	double e0=EliminateEnergy.TBPenergy(E);
	double e=Energy.energy(E,Z);
	System.out.println(e0+" "+e);


	Complex[] FINAL=new Complex[4];
	for(int i=0;i<4;++i) FINAL[i]=new Complex(Z[i]);
	double ee=0;

	for(int i=0;i<4;++i) {
	    Complex w=perturb(i,4,t);

	    for(int q=0;q<4;++q) {
		  Complex ww=new Complex(w);
		  if((q==0)&&(i%2==1)) ww=new Complex(0,0); //keep on x axis
	          Complex[] W=move(q,Z,ww);
	          ee=Energy.energy(E,W);
	          if(ee<e) {
		  for(int j=0;j<4;++j) FINAL[j]=new Complex(W[j]);
	  	  e=ee;
		}
	    }
	}
	return(FINAL);
    }

    /**This routine applies the previous one, for jumpsizes of size 1,1/2,...(1/2)^{50}. **/

    public  Complex[] replace(int[][] E,Complex[] Z) {
	Complex[] FINAL=new Complex[4];
	for(int i=0;i<4;++i) FINAL[i]=new Complex(Z[i]);
	for(int i=0;i<60;++i) {
	    double t=Math.pow(.5,i+10);
	    FINAL=replace(E,FINAL,t);
	}
	return(FINAL);
    }
}





